/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork.generation;

import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.jet.random.engine.RandomEngine;
import islab.bayesian.IProvideMean;
import islab.bayesian.IProvideMeanFactory;
import islab.bayesian.LognormalNoise;
import islab.bayesian.genenetwork.EdgeType;
import islab.bayesian.genenetwork.GeneNetwork;
import islab.bayesian.genenetwork.InteractionType;
import islab.bayesian.genenetwork.NRegulatorsMMHill;
import islab.bayesian.genenetwork.Node;
import islab.bayesian.genenetwork.RandomModel;
import islab.bayesian.genenetwork.SimpleLinearModel;
import islab.lib.RandomElement;
import islab.util.DiscreteUniform;
import java.util.ArrayList;
import java.util.Arrays;

public class InteractionGenerator {
    public static final double PERC_ACT_ECOLI = 0.6102003642987249;
    public static final double PERC_ACT_ECOLI_HONGWU = 0.6787854574510588;
    public static final double PERC_ACT_YEAST = 0.7950594693504117;

    public static void setRandomInteractions(InteractionCategory kind, GeneNetwork gn, double higherOrderProbability, double bioNoiseStddev, RandomElement randomGen) {
        int i = 0;
        while (i < gn.getNNodes()) {
            Node node = gn.getNode(i);
            IProvideMean ipm = null;
            String prefix = null;
            switch (kind) {
                case LINEARLIKE: {
                    ipm = InteractionGenerator.createLinearLikeIPM(node, node.getName(), higherOrderProbability, randomGen);
                    prefix = "LINEARLIKE";
                    break;
                }
                case SIGMOIDAL: {
                    ipm = InteractionGenerator.createSigmoidalIPM(node, node.getName(), higherOrderProbability, randomGen);
                    prefix = "SIGMOIDAL";
                    break;
                }
                case STEP: {
                    ipm = InteractionGenerator.createStepIPM(node, node.getName(), higherOrderProbability, randomGen);
                    prefix = "STEP";
                    break;
                }
                case STEEP: {
                    ipm = InteractionGenerator.createSteepIPM(node, node.getName(), higherOrderProbability, randomGen);
                    prefix = "STEEP";
                    break;
                }
                case LINEAR: {
                    ipm = InteractionGenerator.createLinearIPM(node, node.getName(), higherOrderProbability, randomGen);
                    prefix = "LINEAR";
                    break;
                }
                case MIXED: {
                    ipm = InteractionGenerator.createMixedIPM(node, higherOrderProbability, randomGen);
                    prefix = "MIXED";
                    break;
                }
                case RANDOM: {
                    ipm = InteractionGenerator.createRandomIPM(randomGen);
                    prefix = "RANDOM";
                    break;
                }
                case DEFAULT: {
                    ipm = IProvideMeanFactory.createRandomIPM(node, node.getName(), higherOrderProbability, randomGen);
                    prefix = "DEFAULT";
                    break;
                }
                default: {
                    throw new RuntimeException("Error: don't know how to set interactions");
                }
            }
            LognormalNoise pm = new LognormalNoise(randomGen, ipm, bioNoiseStddev, node);
            InteractionType type = new InteractionType(String.valueOf(prefix) + "_" + i, pm);
            node.setInteractionType(type);
            ++i;
        }
    }

    public static void setEdgeTypes(GeneNetwork gn, double percentActivators, boolean useKnownEdgeTypes, RandomEngine rnd) {
        int n = gn.getNNodes();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                EdgeType t;
                Node to;
                Node from = gn.getNode(i);
                if (gn.isDirectedEdge(from, to = gn.getNode(j)) && (!useKnownEdgeTypes || (t = gn.getEdgeInfo(from, to)) != EdgeType.ACTIVATOR && t != EdgeType.REPRESSOR)) {
                    InteractionGenerator.setEdgeType(gn, from, to, percentActivators, rnd);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void setEdgeType(GeneNetwork gn, Node from, Node to, double percentActivators, RandomEngine rnd) {
        assert (gn.isDirectedEdge(from, to)) : "Edge does not exist";
        if (rnd.nextDouble() <= percentActivators) {
            gn.setEdgeInfo(from, to, EdgeType.ACTIVATOR);
        } else {
            gn.setEdgeInfo(from, to, EdgeType.REPRESSOR);
        }
    }

    public static IProvideMean createSigmoidalIPM(Node node, String name, double higherOrderProbability, RandomElement random) {
        GeneNetwork gn = node.getGeneNetwork();
        ArrayList parents = node.getParents();
        if (parents.size() == 2) {
            Node parent1 = (Node)parents.get(0);
            EdgeType type1 = gn.getEdgeInfo(parent1, node);
            Node parent2 = (Node)parents.get(1);
            EdgeType type2 = gn.getEdgeInfo(parent2, node);
            if (type1 == EdgeType.ACTIVATOR && type2 == EdgeType.ACTIVATOR && random.uniform(0.0, 1.0) < higherOrderProbability) {
                return IProvideMeanFactory.createTwoActivatorsSynergism(name, random);
            }
        }
        int cntActivators = 0;
        int cntRepressors = 0;
        int i = 0;
        while (i < parents.size()) {
            Node parent = (Node)parents.get(i);
            if (gn.getEdgeInfo(parent, node) == EdgeType.ACTIVATOR) {
                ++cntActivators;
            } else if (gn.getEdgeInfo(parent, node) == EdgeType.REPRESSOR) {
                ++cntRepressors;
            } else {
                throw new RuntimeException("type should be known");
            }
            ++i;
        }
        int[] type = new int[parents.size()];
        int i2 = 0;
        while (i2 < parents.size()) {
            Node parent = (Node)parents.get(i2);
            EdgeType edgeType = gn.getEdgeInfo(parent, node);
            type[i2] = edgeType == EdgeType.ACTIVATOR ? 1 : (edgeType == EdgeType.REPRESSOR ? 0 : 2);
            ++i2;
        }
        return InteractionGenerator.createSigmoidalNRegulatorsMM(name, parents.size(), type, random);
    }

    public static IProvideMean createSigmoidalNRegulatorsMM(String name, int numReg, int[] type, RandomElement random) {
        double[] Keq = new double[numReg];
        double[] Hill = new double[numReg];
        int i = 0;
        while (i < numReg) {
            Keq[i] = random.raw() * 0.2 + 0.4;
            Hill[i] = random.raw() * 3.0 + 2.0;
            ++i;
        }
        double[] FoldActivation = new double[numReg];
        int i2 = 0;
        while (i2 < numReg) {
            if (type[i2] == 1) {
                FoldActivation[i2] = 20.0;
            }
            if (type[i2] == 0) {
                FoldActivation[i2] = 0.0;
            }
            ++i2;
        }
        double V0max = 0.2;
        return new NRegulatorsMMHill(V0max, FoldActivation, Keq, Hill, type, numReg);
    }

    public static IProvideMean createLinearLikeIPM(Node node, String name, double higherOrderProbability, RandomElement random) {
        GeneNetwork gn = node.getGeneNetwork();
        ArrayList parents = node.getParents();
        if (parents.size() == 2) {
            Node parent1 = (Node)parents.get(0);
            EdgeType type1 = gn.getEdgeInfo(parent1, node);
            Node parent2 = (Node)parents.get(1);
            EdgeType type2 = gn.getEdgeInfo(parent2, node);
            if (type1 == EdgeType.ACTIVATOR && type2 == EdgeType.ACTIVATOR && random.uniform(0.0, 1.0) < higherOrderProbability) {
                return IProvideMeanFactory.createTwoActivatorsSynergism(name, random);
            }
        }
        int cntActivators = 0;
        int cntRepressors = 0;
        int i = 0;
        while (i < parents.size()) {
            Node parent = (Node)parents.get(i);
            if (gn.getEdgeInfo(parent, node) == EdgeType.ACTIVATOR) {
                ++cntActivators;
            } else if (gn.getEdgeInfo(parent, node) == EdgeType.REPRESSOR) {
                ++cntRepressors;
            } else {
                throw new RuntimeException("type should be known");
            }
            ++i;
        }
        int[] type = new int[parents.size()];
        int i2 = 0;
        while (i2 < parents.size()) {
            Node parent = (Node)parents.get(i2);
            EdgeType edgeType = gn.getEdgeInfo(parent, node);
            type[i2] = edgeType == EdgeType.ACTIVATOR ? 1 : (edgeType == EdgeType.REPRESSOR ? 0 : 2);
            ++i2;
        }
        return InteractionGenerator.createLinearNRegulatorsMM(name, parents.size(), type, random);
    }

    public static IProvideMean createLinearNRegulatorsMM(String name, int numReg, int[] type, RandomElement random) {
        double[] Keq = new double[numReg];
        double[] Hill = new double[numReg];
        int i = 0;
        while (i < numReg) {
            if (DiscreteUniform.chooseBinary(random.getRandomEngine()) == 0) {
                Keq[i] = DiscreteUniform.chooseBinary(random.getRandomEngine()) == 0 ? random.raw() * 9.0 + 1.0 : random.raw() * 0.8 + 0.2;
                Hill[i] = 1.0;
            } else {
                Keq[i] = 10.0;
                Hill[i] = random.raw() * 2.0 + 1.0;
            }
            ++i;
        }
        double[] FoldActivation = new double[numReg];
        int i2 = 0;
        while (i2 < numReg) {
            if (type[i2] == 1) {
                FoldActivation[i2] = 20.0;
            }
            if (type[i2] == 0) {
                FoldActivation[i2] = 0.0;
            }
            ++i2;
        }
        double V0max = 0.2;
        return new NRegulatorsMMHill(V0max, FoldActivation, Keq, Hill, type, numReg);
    }

    public static IProvideMean createStepIPM(Node node, String name, double higherOrderProbability, RandomElement random) {
        GeneNetwork gn = node.getGeneNetwork();
        ArrayList parents = node.getParents();
        if (parents.size() == 2) {
            Node parent1 = (Node)parents.get(0);
            EdgeType type1 = gn.getEdgeInfo(parent1, node);
            Node parent2 = (Node)parents.get(1);
            EdgeType type2 = gn.getEdgeInfo(parent2, node);
            if (type1 == EdgeType.ACTIVATOR && type2 == EdgeType.ACTIVATOR && random.uniform(0.0, 1.0) < higherOrderProbability) {
                return IProvideMeanFactory.createTwoActivatorsSynergism(name, random);
            }
        }
        int cntActivators = 0;
        int cntRepressors = 0;
        int i = 0;
        while (i < parents.size()) {
            Node parent = (Node)parents.get(i);
            if (gn.getEdgeInfo(parent, node) == EdgeType.ACTIVATOR) {
                ++cntActivators;
            } else if (gn.getEdgeInfo(parent, node) == EdgeType.REPRESSOR) {
                ++cntRepressors;
            } else {
                throw new RuntimeException("type should be known");
            }
            ++i;
        }
        int[] type = new int[parents.size()];
        int i2 = 0;
        while (i2 < parents.size()) {
            Node parent = (Node)parents.get(i2);
            EdgeType edgeType = gn.getEdgeInfo(parent, node);
            type[i2] = edgeType == EdgeType.ACTIVATOR ? 1 : (edgeType == EdgeType.REPRESSOR ? 0 : 2);
            ++i2;
        }
        return InteractionGenerator.createStepNRegulatorsMM(name, parents.size(), type, random);
    }

    public static IProvideMean createStepNRegulatorsMM(String name, int numReg, int[] type, RandomElement random) {
        double[] Keq = new double[numReg];
        double[] Hill = new double[numReg];
        int i = 0;
        while (i < numReg) {
            Keq[i] = random.raw() * 0.8 + 0.1;
            Hill[i] = 20.0;
            ++i;
        }
        double[] FoldActivation = new double[numReg];
        int i2 = 0;
        while (i2 < numReg) {
            if (type[i2] == 1) {
                FoldActivation[i2] = 20.0;
            }
            if (type[i2] == 0) {
                FoldActivation[i2] = 0.0;
            }
            ++i2;
        }
        double V0max = 0.2;
        return new NRegulatorsMMHill(V0max, FoldActivation, Keq, Hill, type, numReg);
    }

    public static IProvideMean createSteepIPM(Node node, String name, double higherOrderProbability, RandomElement random) {
        GeneNetwork gn = node.getGeneNetwork();
        ArrayList parents = node.getParents();
        if (parents.size() == 2) {
            Node parent1 = (Node)parents.get(0);
            EdgeType type1 = gn.getEdgeInfo(parent1, node);
            Node parent2 = (Node)parents.get(1);
            EdgeType type2 = gn.getEdgeInfo(parent2, node);
            if (type1 == EdgeType.ACTIVATOR && type2 == EdgeType.ACTIVATOR && random.uniform(0.0, 1.0) < higherOrderProbability) {
                return IProvideMeanFactory.createTwoActivatorsSynergism(name, random);
            }
        }
        int cntActivators = 0;
        int cntRepressors = 0;
        int i = 0;
        while (i < parents.size()) {
            Node parent = (Node)parents.get(i);
            if (gn.getEdgeInfo(parent, node) == EdgeType.ACTIVATOR) {
                ++cntActivators;
            } else if (gn.getEdgeInfo(parent, node) == EdgeType.REPRESSOR) {
                ++cntRepressors;
            } else {
                throw new RuntimeException("type should be known");
            }
            ++i;
        }
        int[] type = new int[parents.size()];
        int i2 = 0;
        while (i2 < parents.size()) {
            Node parent = (Node)parents.get(i2);
            EdgeType edgeType = gn.getEdgeInfo(parent, node);
            type[i2] = edgeType == EdgeType.ACTIVATOR ? 1 : (edgeType == EdgeType.REPRESSOR ? 0 : 2);
            ++i2;
        }
        return InteractionGenerator.createSteepNRegulatorsMM(name, parents.size(), type, random);
    }

    public static IProvideMean createSteepNRegulatorsMM(String name, int numReg, int[] type, RandomElement random) {
        double[] Keq = new double[numReg];
        double[] Hill = new double[numReg];
        int i = 0;
        while (i < numReg) {
            if (DiscreteUniform.chooseBinary(random.getRandomEngine()) == 0) {
                Keq[i] = random.raw() * 0.19 + 0.01;
                Hill[i] = 1.0;
            } else {
                Keq[i] = 10.0;
                Hill[i] = random.raw() * 7.0 + 3.0;
            }
            ++i;
        }
        double[] FoldActivation = new double[numReg];
        int i2 = 0;
        while (i2 < numReg) {
            if (type[i2] == 1) {
                FoldActivation[i2] = 20.0;
            }
            if (type[i2] == 0) {
                FoldActivation[i2] = 0.0;
            }
            ++i2;
        }
        double V0max = 0.2;
        return new NRegulatorsMMHill(V0max, FoldActivation, Keq, Hill, type, numReg);
    }

    public static IProvideMean createLinearIPM(Node node, String name, double higherOrderProbability, RandomElement random) {
        GeneNetwork gn = node.getGeneNetwork();
        ArrayList parents = node.getParents();
        if (parents.size() == 2) {
            Node parent1 = (Node)parents.get(0);
            EdgeType type1 = gn.getEdgeInfo(parent1, node);
            Node parent2 = (Node)parents.get(1);
            EdgeType type2 = gn.getEdgeInfo(parent2, node);
            if (type1 == EdgeType.ACTIVATOR && type2 == EdgeType.ACTIVATOR && random.uniform(0.0, 1.0) < higherOrderProbability) {
                return IProvideMeanFactory.createTwoActivatorsSynergism(name, random);
            }
        }
        int cntActivators = 0;
        int cntRepressors = 0;
        int i = 0;
        while (i < parents.size()) {
            Node parent = (Node)parents.get(i);
            if (gn.getEdgeInfo(parent, node) == EdgeType.ACTIVATOR) {
                ++cntActivators;
            } else if (gn.getEdgeInfo(parent, node) == EdgeType.REPRESSOR) {
                ++cntRepressors;
            } else {
                throw new RuntimeException("type should be known");
            }
            ++i;
        }
        int[] type = new int[parents.size()];
        int i2 = 0;
        while (i2 < parents.size()) {
            Node parent = (Node)parents.get(i2);
            EdgeType edgeType = gn.getEdgeInfo(parent, node);
            type[i2] = edgeType == EdgeType.ACTIVATOR ? 1 : (edgeType == EdgeType.REPRESSOR ? 0 : 2);
            ++i2;
        }
        return InteractionGenerator.createLinearNRegulators(name, parents.size(), type, random);
    }

    public static IProvideMean createLinearNRegulators(String name, int numReg, int[] type, RandomElement random) {
        double[] coeff = new double[numReg + 1];
        coeff[0] = 0.0;
        int i = 0;
        while (i < numReg) {
            if (type[i] == 1) {
                coeff[i + 1] = 1.0;
            }
            if (type[i] == 0) {
                coeff[i + 1] = -1.0;
            }
            ++i;
        }
        SimpleLinearModel lm = new SimpleLinearModel(numReg);
        lm.setB(new DenseDoubleMatrix1D(coeff));
        return lm;
    }

    public static IProvideMean createRandomIPM(RandomElement random) {
        return InteractionGenerator.createRandomNRegulators(random);
    }

    public static IProvideMean createRandomNRegulators(RandomElement random) {
        RandomModel rm = new RandomModel(random.getRandomEngine().nextInt());
        return rm;
    }

    public static IProvideMean createMixedIPM(Node node, double higherOrderProbability, RandomElement randomGen) {
        ArrayList categories = new ArrayList();
        categories.addAll(Arrays.asList(InteractionCategory.values()));
        categories.remove((Object)InteractionCategory.MIXED);
        categories.remove((Object)InteractionCategory.RANDOM);
        categories.remove((Object)InteractionCategory.DEFAULT);
        InteractionCategory choice = (InteractionCategory)((Object)DiscreteUniform.pickOne(categories, randomGen.getRandomEngine()));
        switch (choice) {
            case LINEARLIKE: {
                return InteractionGenerator.createLinearLikeIPM(node, node.getName(), higherOrderProbability, randomGen);
            }
            case SIGMOIDAL: {
                return InteractionGenerator.createSigmoidalIPM(node, node.getName(), higherOrderProbability, randomGen);
            }
            case STEP: {
                return InteractionGenerator.createStepIPM(node, node.getName(), higherOrderProbability, randomGen);
            }
            case STEEP: {
                return InteractionGenerator.createSteepIPM(node, node.getName(), higherOrderProbability, randomGen);
            }
            case LINEAR: {
                return InteractionGenerator.createLinearIPM(node, node.getName(), higherOrderProbability, randomGen);
            }
        }
        throw new RuntimeException("cannot create interaction type " + (Object)((Object)choice) + ": do not know how");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InteractionCategory {
        LINEARLIKE,
        SIGMOIDAL,
        STEP,
        STEEP,
        LINEAR,
        MIXED,
        DEFAULT,
        RANDOM;

    }
}

