/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork.generation;

import cern.jet.random.engine.MersenneTwister;
import islab.bayesian.DataSet;
import islab.bayesian.genenetwork.CreateNetworkException;
import islab.bayesian.genenetwork.GeneNetwork;
import islab.bayesian.genenetwork.generation.DataGenerator;
import islab.bayesian.genenetwork.generation.ExternalNodeNotFoundException;
import islab.bayesian.genenetwork.generation.GeneNetworkGenerator;
import islab.bayesian.genenetwork.generation.IniSettings;
import islab.bayesian.genenetwork.generation.InteractionGenerator;
import islab.lib.DelimitedFileReader;
import islab.lib.RandomElement;
import islab.lib.XmlHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class NetworkGeneratorCLI {
    public static void generateData(IniSettings is) {
        String xmlFile = is.xmlFile;
        double bioNoise = is.bioNoise;
        double expNoise = is.expNoise;
        double inputNoise = is.inputNoise;
        int burnIn = is.burnIn;
        int nrExperiments = is.nrExperiments;
        int nrSamplesPerExperiment = is.nrSamplesPerExp;
        MersenneTwister engine = new MersenneTwister(is.randomSeed);
        RandomElement rnd = new RandomElement(engine);
        GeneNetwork gn = null;
        try {
            gn = GeneNetwork.fromXMLFile(rnd, xmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DataSet[] ds = null;
        switch (is.externalInputValues) {
            case RANDOMIZED: {
                ds = DataGenerator.generateDataSetsRandomizedExternals(gn, burnIn, nrSamplesPerExperiment, nrExperiments, inputNoise, bioNoise, expNoise, rnd);
                break;
            }
            case FIXED: {
                ds = DataGenerator.generateDataSetsWithoutRandomizingExternals(gn, burnIn, nrSamplesPerExperiment, inputNoise, bioNoise, expNoise, rnd);
                break;
            }
            case FROM_EXTERNALS_FILE: {
                try {
                    DelimitedFileReader externalConditions = new DelimitedFileReader(is.externalsFile);
                    ds = DataGenerator.generateDataSetsPredefinedExternals(gn, burnIn, nrSamplesPerExperiment, externalConditions, inputNoise, bioNoise, expNoise, rnd);
                    break;
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                    break;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    break;
                }
                catch (ExternalNodeNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
        }
        String fname = String.format("sampled_bionoise_%.2f_expnoise_%.2f_inputnoise_%.2f_burnin_%d_experiments_%d_samples_%d", bioNoise, expNoise, inputNoise, burnIn, nrExperiments, nrSamplesPerExperiment);
        try {
            new File(is.outputdir).mkdirs();
            ds[0].saveToFile(String.valueOf(is.outputdir) + "/" + fname + "_normalized_dataset.txt", true);
            ds[1].saveToFile(String.valueOf(is.outputdir) + "/" + fname + "_unnormalized_dataset.txt", true);
        }
        catch (IOException e) {
            System.err.println("ERROR could not save expression data: " + e.getStackTrace().toString());
            System.err.println("  " + is.outputdir + "/" + fname + "_normalized_dataset.txt");
        }
    }

    public static void createRandomGeneNetworkFromSIFSubNetwork(IniSettings is) {
        String subnetworkSelection = is.subnetworkSelection;
        String siffilename = is.sifFile;
        String networkfilename = is.xmlFile;
        int nrExternals = is.nrExternals;
        int nrCorr = is.nrCorrelatedExternals;
        int nrNodes = is.nrNodes;
        int nrBackgroundNodes = is.nrBackgroundNodes;
        double higherOrderProbability = is.higherOrderProbability;
        double percentActivators = is.percentActivators;
        boolean useEdgeTypesFromSIF = is.useEdgeTypesFromSIF;
        InteractionGenerator.InteractionCategory interactionCategory = is.interactionCategory;
        MersenneTwister engine = new MersenneTwister(is.randomSeed);
        RandomElement rnd = new RandomElement(engine);
        GeneNetwork gn = null;
        try {
            gn = GeneNetworkGenerator.createRandomizedGNFromSIFFileSubnetwork(subnetworkSelection, siffilename, nrNodes, nrBackgroundNodes, nrExternals, nrCorr, 0.0, 0.0, 0.0, higherOrderProbability, percentActivators, useEdgeTypesFromSIF, interactionCategory, rnd);
        }
        catch (CreateNetworkException e) {
            e.printStackTrace();
        }
        try {
            XmlHelper.saveToFile(networkfilename, gn.toXML(""));
            String subnetworkfilename = siffilename.endsWith(".sif") || siffilename.endsWith(".SIF") ? String.valueOf(siffilename.substring(0, siffilename.length() - 4)) + "_nodes_" + nrNodes + "_bgrnodes_" + nrBackgroundNodes + "_subnetwork.sif" : String.valueOf(siffilename) + "_nodes_" + nrNodes + "_bgrnodes_" + nrBackgroundNodes + "_subnetwork";
            PrintWriter pw = new PrintWriter(new FileWriter(subnetworkfilename));
            GeneNetworkGenerator.subnetIM.toSIF(pw);
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createRandomGeneNetworkFromSIFComplete(IniSettings is) {
        String siffilename = is.sifFile;
        String networkfilename = is.xmlFile;
        int nrExternals = is.nrExternals;
        double higherOrderProbability = is.higherOrderProbability;
        double percentActivators = is.percentActivators;
        boolean useEdgeTypesFromSIF = is.useEdgeTypesFromSIF;
        InteractionGenerator.InteractionCategory interactionCategory = is.interactionCategory;
        MersenneTwister engine = new MersenneTwister(is.randomSeed);
        RandomElement rnd = new RandomElement(engine);
        GeneNetwork gn = null;
        try {
            gn = GeneNetworkGenerator.createRandomizedGNFromCompleteSIFFile(siffilename, nrExternals, 0, 0.0, 0.0, 0.0, higherOrderProbability, percentActivators, useEdgeTypesFromSIF, interactionCategory, rnd);
        }
        catch (CreateNetworkException e) {
            e.printStackTrace();
        }
        try {
            XmlHelper.saveToFile(networkfilename, gn.toXML(""));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createRandomGeneNetworkFromSIFExternalsFixed(IniSettings is) {
        String siffilename = is.sifFile;
        String networkfilename = is.xmlFile;
        String externalsfilename = is.externalsFile;
        double higherOrderProbability = is.higherOrderProbability;
        double percentActivators = is.percentActivators;
        boolean useEdgeTypesFromSIF = is.useEdgeTypesFromSIF;
        InteractionGenerator.InteractionCategory interactionCategory = is.interactionCategory;
        MersenneTwister engine = new MersenneTwister(is.randomSeed);
        RandomElement rnd = new RandomElement(engine);
        GeneNetwork gn = null;
        try {
            gn = GeneNetworkGenerator.createRandomizedGNFromCompleteSIFFileExternalsFixed(siffilename, externalsfilename, 0, 0.0, 0.0, 0.0, higherOrderProbability, percentActivators, useEdgeTypesFromSIF, interactionCategory, rnd);
        }
        catch (CreateNetworkException e) {
            e.printStackTrace();
        }
        try {
            XmlHelper.saveToFile(networkfilename, gn.toXML(""));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void run(IniSettings is) {
        if (is.createGeneNetwork) {
            if (is.selectSubnetwork) {
                NetworkGeneratorCLI.createRandomGeneNetworkFromSIFSubNetwork(is);
            } else if (is.fixedExternals) {
                NetworkGeneratorCLI.createRandomGeneNetworkFromSIFExternalsFixed(is);
            } else {
                NetworkGeneratorCLI.createRandomGeneNetworkFromSIFComplete(is);
            }
        }
        if (is.generateExpressionData) {
            NetworkGeneratorCLI.generateData(is);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: NetworkGeneratorCLI <ini-file>");
            System.exit(1);
        }
        String iniFile = args[0];
        IniSettings is = new IniSettings(iniFile);
        NetworkGeneratorCLI.run(is);
    }
}

