/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork.generation;

import cern.jet.random.engine.MersenneTwister;
import islab.bayesian.genenetwork.generation.ExpressionDataGeneration;
import islab.lib.RandomElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class NetworkGeneratorGUI
extends JFrame
implements ActionListener {
    JMenuBar menuBar;
    JMenuItem mnAbout;
    JLabel lBurnin = new JLabel("Burnin period");
    JTextField tBurnin = new JTextField("1000");
    JLabel lNrExperiments = new JLabel("Nr experiments");
    JTextField tNrExperiments = new JTextField("100");
    JLabel lNrS = new JLabel("Nr samples per experiment");
    JTextField tNrS = new JTextField("1");
    JLabel lNrNodes = new JLabel("Nr nodes");
    JTextField tNrNodes = new JTextField("100");
    JLabel lNrBgrNodes = new JLabel("Nr background nodes");
    JTextField tNrBgrNodes = new JTextField("100");
    JLabel lHOP = new JLabel("Probability for complex 2-regulator interactions");
    JTextField tHOP = new JTextField("0.3");
    JLabel lBioNoise = new JLabel("Biological noise [0..1]");
    JTextField tBioNoise = new JTextField("0.1");
    JLabel lExpNoise = new JLabel("Experimental noise [0..1]");
    JTextField tExpNoise = new JTextField("0.1");
    JLabel lCorrelatedNoise = new JLabel("Noise on correlated inputs [0..1] ");
    JTextField tCorrelatedNoise = new JTextField("0.1");
    JLabel lNrExternal = new JLabel("Nr external nodes (-1 for all topnodes)");
    JTextField tNrExternal = new JTextField("-1");
    JLabel lNrCorrelated = new JLabel("Nr correlated external nodes (-1 for 50% of the external nodes)");
    JTextField tNrCorrelated = new JTextField("-1");
    JLabel lSelType = new JLabel("Subnetwork selection method");
    JComboBox cbSelType = new JComboBox<String>(new String[]{"neigbor addition", "cluster addition"});
    JLabel lSourceFile = new JLabel("Source network");
    JTextField tSourceFile = new JTextField("./data/sourceNetworks/EColi_full.sif");
    JButton bSourceFile = new JButton("...");
    JLabel lSavePath = new JLabel("Save files to path");
    JTextField tSavePath = new JTextField("./data/results/");
    JButton bSavePath = new JButton("...");
    JLabel lRndSeed = new JLabel("Random seed");
    JTextField tRndSeed = new JTextField("13");
    JButton bRun = new JButton("Generate datasets (~ 1 minute)");

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bSavePath) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.tSavePath.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        } else if (e.getSource() == this.bSourceFile) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.tSourceFile.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        } else if (e.getSource() == this.bRun) {
            try {
                ExpressionDataGeneration.generateDataSets(Integer.parseInt(this.tBurnin.getText()), Integer.parseInt(this.tNrS.getText()), Integer.parseInt(this.tNrExperiments.getText()), new int[]{Integer.parseInt(this.tNrNodes.getText())}, new int[]{Integer.parseInt(this.tNrBgrNodes.getText())}, new double[]{Double.parseDouble(this.tHOP.getText())}, new double[]{Double.parseDouble(this.tBioNoise.getText())}, new double[]{Double.parseDouble(this.tExpNoise.getText())}, Double.parseDouble(this.tCorrelatedNoise.getText()), Integer.parseInt(this.tNrExternal.getText()), Integer.parseInt(this.tNrCorrelated.getText()), this.cbSelType.getSelectedIndex() != 0, this.tSourceFile.getText(), String.valueOf(this.tSavePath.getText()) + System.getProperty("file.separator"), new RandomElement(new MersenneTwister(Integer.parseInt(this.tRndSeed.getText()))));
                JOptionPane.showMessageDialog(this, "Files saved");
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "An error occurred while parsing the input parameters. Please check the number format for all of the fields:\n" + ex.getMessage(), "Error message", 0);
            }
        } else if (e.getSource() == this.mnAbout) {
            SimpleAboutDialog dlgAbout = new SimpleAboutDialog(this);
            dlgAbout.setVisible(true);
        }
    }

    private JMenuBar generateMenu() {
        this.menuBar = new JMenuBar();
        this.mnAbout = new JMenuItem("About", 65);
        this.mnAbout.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.mnAbout.addActionListener(this);
        this.menuBar.add(this.mnAbout);
        return this.menuBar;
    }

    public NetworkGeneratorGUI() {
        this.setDefaultCloseOperation(3);
        this.setTitle("SynTReN: Synthetic Transcriptional Regulatory Networks");
        this.setJMenuBar(this.generateMenu());
        Container cp = this.getContentPane();
        JPanel pMain = new JPanel();
        pMain.setLayout(new BorderLayout());
        JPanel pFields = new JPanel();
        pFields.setSize(800, 500);
        pFields.setLayout(new GridLayout(0, 2));
        this.lBurnin.setLabelFor(this.tBurnin);
        pFields.add(this.lBurnin);
        pFields.add(this.tBurnin);
        this.lNrExperiments.setLabelFor(this.tNrExperiments);
        pFields.add(this.lNrExperiments);
        pFields.add(this.tNrExperiments);
        this.lNrS.setLabelFor(this.tNrS);
        pFields.add(this.lNrS);
        pFields.add(this.tNrS);
        this.lNrNodes.setLabelFor(this.tNrNodes);
        pFields.add(this.lNrNodes);
        pFields.add(this.tNrNodes);
        this.lNrBgrNodes.setLabelFor(this.tNrBgrNodes);
        pFields.add(this.lNrBgrNodes);
        pFields.add(this.tNrBgrNodes);
        this.lHOP.setLabelFor(this.tHOP);
        pFields.add(this.lHOP);
        pFields.add(this.tHOP);
        this.lBioNoise.setLabelFor(this.tBioNoise);
        pFields.add(this.lBioNoise);
        pFields.add(this.tBioNoise);
        this.lExpNoise.setLabelFor(this.tExpNoise);
        pFields.add(this.lExpNoise);
        pFields.add(this.tExpNoise);
        this.lCorrelatedNoise.setLabelFor(this.lCorrelatedNoise);
        pFields.add(this.lCorrelatedNoise);
        pFields.add(this.tCorrelatedNoise);
        this.lNrExternal.setLabelFor(this.tNrExternal);
        pFields.add(this.lNrExternal);
        pFields.add(this.tNrExternal);
        this.lNrCorrelated.setLabelFor(this.tNrCorrelated);
        pFields.add(this.lNrCorrelated);
        pFields.add(this.tNrCorrelated);
        this.lSelType.setLabelFor(this.cbSelType);
        pFields.add(this.lSelType);
        pFields.add(this.cbSelType);
        this.lSourceFile.setLabelFor(this.tSourceFile);
        this.bSourceFile.addActionListener(this);
        GridBagLayout gl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel gSourceFile = new JPanel();
        gSourceFile.setLayout(gl);
        c.fill = 2;
        c.weightx = 1.0;
        gl.setConstraints(this.tSourceFile, c);
        gSourceFile.add((Component)this.tSourceFile, c);
        c.weightx = 0.05;
        c.gridwidth = 0;
        gl.setConstraints(this.bSourceFile, c);
        gSourceFile.add(this.bSourceFile);
        pFields.add(this.lSourceFile);
        pFields.add(gSourceFile);
        this.lSavePath.setLabelFor(this.tSavePath);
        this.bSavePath.addActionListener(this);
        GridBagLayout gl2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        JPanel gSavePath = new JPanel();
        gSavePath.setLayout(gl2);
        c2.fill = 2;
        c2.weightx = 1.0;
        gl.setConstraints(this.tSavePath, c2);
        gSavePath.add((Component)this.tSavePath, c2);
        c2.weightx = 0.05;
        c2.gridwidth = 0;
        gl2.setConstraints(this.bSavePath, c2);
        gSavePath.add(this.bSavePath);
        pFields.add(this.lSavePath);
        pFields.add(gSavePath);
        this.lRndSeed.setLabelFor(this.tRndSeed);
        pFields.add(this.lRndSeed);
        pFields.add(this.tRndSeed);
        this.bRun.addActionListener(this);
        pMain.add((Component)pFields, "Center");
        pMain.add((Component)this.bRun, "South");
        cp.add(pMain);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        NetworkGeneratorGUI f = new NetworkGeneratorGUI();
    }

    public class SimpleAboutDialog
    extends JDialog {
        private static final long serialVersionUID = 6939039203960730489L;

        public SimpleAboutDialog(JFrame parent) {
            super(parent, "About Dialog", true);
            Box b = Box.createVerticalBox();
            b.setAlignmentX(0.5f);
            b.add(Box.createGlue());
            JLabel version = new JLabel("Version: 1.1.3");
            version.setAlignmentX(0.5f);
            version.setFont(new Font("Arial", 0, 12));
            b.add(version);
            JLabel date = new JLabel("Date: 2006-03-23");
            date.setAlignmentX(0.5f);
            date.setFont(new Font("Arial", 0, 12));
            b.add(date);
            JLabel title = new JLabel("Paper: SynTReN: a synthetic gene expression data generator for validation of reverse engineering methods");
            title.setFont(new Font("Arial", 1, 12));
            title.setAlignmentX(0.5f);
            b.add(title);
            JLabel authors1 = new JLabel("Authors:");
            JLabel authors2 = new JLabel("Tim Van den Bulcke*, Koenraad Van Leemput*");
            JLabel authors3 = new JLabel("Bart Naudts, Piet van Remortel, Hongwu Ma, Alain Verschoren, Bart De Moor, Kathleen Marchal");
            JLabel contrib = new JLabel("* contributed equally");
            authors1.setAlignmentX(0.5f);
            authors2.setAlignmentX(0.5f);
            authors3.setAlignmentX(0.5f);
            contrib.setAlignmentX(0.5f);
            authors1.setFont(new Font("Arial", 0, 12));
            authors2.setFont(new Font("Arial", 2, 12));
            authors3.setFont(new Font("Arial", 2, 12));
            contrib.setFont(new Font("Arial", 2, 10));
            b.add(authors1);
            b.add(authors2);
            b.add(authors3);
            b.add(Box.createGlue());
            b.add(contrib);
            b.add(Box.createGlue());
            this.getContentPane().add((Component)b, "Center");
            JPanel p2 = new JPanel();
            JButton ok = new JButton("Ok");
            p2.add(ok);
            this.getContentPane().add((Component)p2, "South");
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SimpleAboutDialog.this.setVisible(false);
                }
            });
            this.setSize(700, 200);
            this.setLocationRelativeTo(null);
        }
    }
}

