/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork.generation.random;

import cern.jet.random.EmpiricalWalker;
import cern.jet.random.engine.MersenneTwister;
import islab.bayesian.genenetwork.GeneNetwork;
import islab.bayesian.genenetwork.InteractionType;
import islab.bayesian.genenetwork.Node;
import islab.lib.RandomElement;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class AlbertBarabasiGenerator {
    private static int nodeNum;
    private static int edgeNum;
    private static ArrayList degrees;

    public static GeneNetwork create(int m0, int m, double p, double q, int steps, RandomElement random) {
        return AlbertBarabasiGenerator.create(m0, m, p, q, steps, 0.5, random);
    }

    public static GeneNetwork create(int m0, int m, double p, double q, int steps, double probNewEdgeIsOutgoing, RandomElement random) {
        Node n;
        assert (m0 > 1) : "initial nb of isolated nodes has to be > 1";
        assert (m > 0) : "nb of links modified per step has to be > 0";
        assert (m <= m0) : "m has to be <= m0";
        assert (p + q < 1.0) : "prob p+q has to be < 1";
        assert (probNewEdgeIsOutgoing <= 1.0 && probNewEdgeIsOutgoing >= 0.0) : "should be between 0 and 1";
        nodeNum = 0;
        edgeNum = 0;
        degrees = new ArrayList();
        GeneNetwork ABnet = new GeneNetwork();
        int i = 0;
        while (i < m0) {
            n = new Node(nodeNum);
            n.setInteractionType(new InteractionType("Unknown", null));
            ABnet.addNode(n);
            degrees.add(nodeNum, new Integer(0));
            ++nodeNum;
            ++i;
        }
        i = 0;
        while (i < steps) {
            Node tmp;
            Node tail;
            Node head;
            int idx2;
            int idx1;
            int j;
            double draw = random.raw();
            if (draw <= p) {
                j = 0;
                while (j < m) {
                    idx1 = random.choose(0, nodeNum - 1);
                    idx2 = AlbertBarabasiGenerator.selectPref(idx1, random);
                    assert (idx1 != idx2) : "cannot add a self edge in Albert-Barabasi";
                    head = ABnet.getNode(idx1);
                    if (!ABnet.isDirectedEdge(head, tail = ABnet.getNode(idx2)) && !ABnet.isDirectedEdge(tail, head)) {
                        if (random.raw() > probNewEdgeIsOutgoing) {
                            tmp = head;
                            head = tail;
                            tail = tmp;
                        }
                        ABnet.addDirectedEdge(head, tail);
                        ++edgeNum;
                        AlbertBarabasiGenerator.incrementDegree(idx1);
                        AlbertBarabasiGenerator.incrementDegree(idx2);
                    }
                    ++j;
                }
            } else if (draw > p && draw <= p + q) {
                j = 0;
                while (j < m) {
                    idx1 = random.choose(0, nodeNum - 1);
                    head = ABnet.getNode(idx1);
                    ArrayList children = head.getChildren();
                    ArrayList neighbours = new ArrayList(children);
                    neighbours.addAll(head.getParents());
                    if (neighbours.size() <= 0) {
                        --j;
                    } else {
                        int choice = random.choose(0, neighbours.size() - 1);
                        idx2 = ((Node)neighbours.get(choice)).getIndex();
                        if (children.contains(ABnet.getNode(idx2))) {
                            ABnet.removeDirectedEdge(ABnet.getNode(idx1), ABnet.getNode(idx2));
                        } else {
                            ABnet.removeDirectedEdge(ABnet.getNode(idx2), ABnet.getNode(idx1));
                        }
                        --edgeNum;
                        AlbertBarabasiGenerator.decrementDegree(idx1);
                        AlbertBarabasiGenerator.decrementDegree(idx2);
                        idx2 = AlbertBarabasiGenerator.selectPref(idx1, random);
                        assert (idx1 != idx2) : "cannot add a self edge in Albert-Barabasi";
                        tail = ABnet.getNode(idx2);
                        if (!ABnet.isDirectedEdge(head, tail) && !ABnet.isDirectedEdge(tail, head)) {
                            if (children.contains(tail)) {
                                Node tmp2 = head;
                                head = tail;
                                tail = tmp2;
                            }
                            ABnet.addDirectedEdge(head, tail);
                            ++edgeNum;
                            AlbertBarabasiGenerator.incrementDegree(idx1);
                            AlbertBarabasiGenerator.incrementDegree(idx2);
                        }
                    }
                    ++j;
                }
            } else {
                n = new Node(nodeNum);
                n.setInteractionType(new InteractionType("Unknown", null));
                ABnet.addNode(n);
                degrees.add(nodeNum, new Integer(0));
                idx1 = nodeNum++;
                j = 0;
                while (j < m) {
                    idx2 = AlbertBarabasiGenerator.selectPref(idx1, random);
                    assert (idx1 != idx2) : "cannot add a self edge in Albert-Barabasi";
                    head = ABnet.getNode(idx1);
                    if (!ABnet.isDirectedEdge(head, tail = ABnet.getNode(idx2)) && !ABnet.isDirectedEdge(tail, head)) {
                        if (random.raw() > probNewEdgeIsOutgoing) {
                            tmp = head;
                            head = tail;
                            tail = tmp;
                        }
                        ABnet.addDirectedEdge(head, tail);
                        ++edgeNum;
                        AlbertBarabasiGenerator.incrementDegree(idx1);
                        AlbertBarabasiGenerator.incrementDegree(idx2);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ABnet;
    }

    private static void incrementDegree(int node) {
        degrees.set(node, new Integer((Integer)degrees.get(node) + 1));
    }

    private static void decrementDegree(int node) {
        degrees.set(node, new Integer((Integer)degrees.get(node) - 1));
    }

    private static int selectPref(int source, RandomElement random) {
        double[] pdf = new double[nodeNum];
        pdf[source] = 0.0;
        int i = 0;
        while (i < nodeNum) {
            if (i != source) {
                pdf[i] = AlbertBarabasiGenerator.pref(i);
            }
            ++i;
        }
        EmpiricalWalker e = new EmpiricalWalker(pdf, 1, random.getRandomEngine());
        return e.nextInt();
    }

    private static double pref(int node) {
        int sum = 0;
        int i = 0;
        while (i < nodeNum) {
            if (i != node) {
                sum += (Integer)degrees.get(i) + 1;
            }
            ++i;
        }
        return (double)((Integer)degrees.get(node)).intValue() + 1.0 / (double)sum;
    }

    public static void main(String[] args) {
        if (args.length != 6) {
            System.err.println("parameters: initialNodes modificationsPerStep p q steps seed");
            System.exit(1);
        }
        int m0 = new Integer(args[0]);
        int m = new Integer(args[1]);
        double p = new Double(args[2]);
        double q = new Double(args[3]);
        int steps = new Integer(args[4]);
        int seed = new Integer(args[5]);
        MersenneTwister mt = new MersenneTwister(seed);
        GeneNetwork g = AlbertBarabasiGenerator.create(m0, m, p, q, steps, new RandomElement(mt));
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream("/home/koenv/tmp/output.sif"));
            g.toSIF(out);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

