/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork.generation.random;

import cern.jet.random.EmpiricalWalker;
import islab.bayesian.genenetwork.GeneNetwork;
import islab.bayesian.genenetwork.Node;
import islab.lib.RandomElement;

public class DirectedScaleFreeGenerator {
    public static GeneNetwork create(double alpha, double beta, double deltaIn, double deltaOut, GeneNetwork initialNetwork, int steps, RandomElement random) {
        GeneNetwork network = initialNetwork;
        int LIMIT = 1000;
        int i = 0;
        while (i < steps) {
            Node tail;
            Node head;
            double draw;
            if (i % 100 == 0) {
                System.out.println("i=" + i + "   network nr nodes=" + network.getNNodes());
            }
            if ((draw = random.raw()) <= alpha) {
                head = new Node(network, network.getNNodes());
                if (network.isDirectedEdge(head, tail = DirectedScaleFreeGenerator.selectRandomIn(network, deltaIn, random))) {
                    throw new RuntimeException("error in DirectedScaleFreeGenerator.create(): edge already exists, impossible!");
                }
                network.addDirectedEdge(head, tail);
            } else if (draw <= alpha + beta) {
                for (int cntr = 0; cntr < 1000; ++cntr) {
                    head = DirectedScaleFreeGenerator.selectRandomOut(network, deltaOut, random);
                    if (network.isDirectedEdge(head, tail = DirectedScaleFreeGenerator.selectRandomIn(network, deltaIn, random))) continue;
                    network.addDirectedEdge(head, tail);
                    break;
                }
            } else {
                head = DirectedScaleFreeGenerator.selectRandomOut(network, deltaOut, random);
                if (!network.isDirectedEdge(head, tail = new Node(network, network.getNNodes()))) {
                    network.addDirectedEdge(head, tail);
                }
            }
            ++i;
        }
        return network;
    }

    public static GeneNetwork createMaxNodes(double alpha, double beta, double deltaIn, double deltaOut, GeneNetwork initialNetwork, int maxSteps, int maxNodes, RandomElement random) {
        GeneNetwork network = initialNetwork;
        int LIMIT = 1000;
        int i = 0;
        while (i < maxSteps) {
            block11: {
                block8: {
                    Node tail;
                    Node head;
                    block10: {
                        double draw;
                        block9: {
                            if (i % 100 == 0) {
                                System.out.println("i=" + i + "   network nr nodes=" + network.getNNodes());
                            }
                            if (!((draw = random.raw()) <= alpha)) break block9;
                            head = new Node(network, network.getNNodes());
                            if (network.isDirectedEdge(head, tail = DirectedScaleFreeGenerator.selectRandomIn(network, deltaIn, random))) {
                                throw new RuntimeException("error in DirectedScaleFreeGenerator.create(): edge already exists, impossible!");
                            }
                            network.addDirectedEdge(head, tail);
                            break block8;
                        }
                        if (!(draw <= alpha + beta)) break block10;
                        for (int cntr = 0; cntr < 1000; ++cntr) {
                            head = DirectedScaleFreeGenerator.selectRandomOut(network, deltaOut, random);
                            if (network.isDirectedEdge(head, tail = DirectedScaleFreeGenerator.selectRandomIn(network, deltaIn, random))) continue;
                            network.addDirectedEdge(head, tail);
                            break block8;
                        }
                        break block8;
                    }
                    head = DirectedScaleFreeGenerator.selectRandomOut(network, deltaOut, random);
                    if (network.isDirectedEdge(head, tail = new Node(network, network.getNNodes()))) break block11;
                    network.addDirectedEdge(head, tail);
                }
                if (network.getNNodes() == maxNodes) {
                    return network;
                }
            }
            ++i;
        }
        return network;
    }

    private static Node selectRandomOut(GeneNetwork gn, double deltaOut, RandomElement random) {
        double[] probNodes = new double[gn.getNNodes()];
        int i = 0;
        while (i < probNodes.length) {
            probNodes[i] = deltaOut + (double)gn.getNode(i).getChildren().size();
            ++i;
        }
        EmpiricalWalker e = new EmpiricalWalker(probNodes, 1, random.getRandomEngine());
        return gn.getNode(e.nextInt());
    }

    private static Node selectRandomIn(GeneNetwork gn, double deltaIn, RandomElement random) {
        double[] probNodes = new double[gn.getNNodes()];
        int i = 0;
        while (i < probNodes.length) {
            probNodes[i] = deltaIn + (double)gn.getNode(i).getParents().size();
            ++i;
        }
        EmpiricalWalker e = new EmpiricalWalker(probNodes, 1, random.getRandomEngine());
        return gn.getNode(e.nextInt());
    }

    public static void main(String[] args) {
    }
}

