/*
 * Decompiled with CFR 0.152.
 */
package islab.bayesian.genenetwork.generation.random;

import islab.bayesian.genenetwork.GeneNetwork;
import islab.bayesian.genenetwork.InteractionType;
import islab.bayesian.genenetwork.Node;
import islab.lib.Print;
import islab.lib.RandomElement;

public class SmallWorldGenerator {
    public static GeneNetwork create(int n, int k, double p, RandomElement rnd) {
        assert (k < n) : "number of edges per vertex must be smaller than number of vertices";
        assert (k % 2 == 0) : "number of edges per vertex must be even";
        GeneNetwork SWnet = new GeneNetwork();
        int i = 0;
        while (i < n) {
            Node node = new Node(i);
            node.setInteractionType(new InteractionType("Unknown", null));
            SWnet.addNode(node);
            ++i;
        }
        int k_2 = k / 2;
        int i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < k_2) {
                if (rnd.uniform(0.0, 1.0) < 0.5) {
                    SWnet.addDirectedEdge(SWnet.getNode(i2), SWnet.getNode((i2 + j + 1) % n));
                } else {
                    SWnet.addDirectedEdge(SWnet.getNode((i2 + j + 1) % n), SWnet.getNode(i2));
                }
                ++j;
            }
            ++i2;
        }
        int j = 0;
        while (j < k_2) {
            int i3 = 0;
            while (i3 < n) {
                if (rnd.uniform(0.0, 1.0) < p) {
                    Node rndNode = SWnet.getNode(rnd.choose(n) - 1);
                    if (!SWnet.isDirectedEdge(SWnet.getNode(i3), rndNode)) {
                        SWnet.addDirectedEdge(SWnet.getNode(i3), rndNode);
                        SWnet.removeDirectedEdge(SWnet.getNode(i3), SWnet.getNode((i3 + j + 1) % n));
                    }
                }
                ++i3;
            }
            ++j;
        }
        Print.println("done");
        return SWnet;
    }

    public static void main(String[] args) {
    }
}

