/*
 * Decompiled with CFR 0.152.
 */
package islab.lib;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public class DelimitedFileReader {
    private String[] header;
    private ArrayList data = new ArrayList();
    private Hashtable column = new Hashtable();
    private String[] type;
    private String delimiter = "\t";

    public final String getHeader(int column) {
        return this.header[column];
    }

    public final String getString(int i, int j) {
        return ((String[])this.data.get(i))[j];
    }

    public final int getInt(int i, int j) {
        return Integer.parseInt(this.getString(i, j));
    }

    public final float getFloat(int i, int j) {
        return Float.parseFloat(this.getString(i, j));
    }

    public final double getDouble(int i, int j) {
        return Double.parseDouble(this.getString(i, j));
    }

    public final void setValue(int i, int j, String value) {
        ((String[])this.data.get((int)i))[j] = value;
    }

    public final void setValue(int i, int j, double value) {
        this.setValue(i, j, new Double(value).toString());
    }

    public final void setValue(int i, int j, int value) {
        this.setValue(i, j, new Integer(value).toString());
    }

    public final void setValue(int i, int j, float value) {
        this.setValue(i, j, new Float(value).toString());
    }

    public final int getColumn(String colName) {
        Object col = this.column.get(colName);
        if (col == null || !(col instanceof Integer)) {
            return -1;
        }
        return (Integer)col;
    }

    public final String getType(int column) {
        if (this.type != null) {
            return this.type[column];
        }
        return null;
    }

    public final int getNrColumns() {
        return this.header.length;
    }

    public final int getNrRows() {
        return this.data.size();
    }

    private static String chomp(String s) {
        if (s.endsWith("\r\n")) {
            return s.substring(0, s.length() - 3);
        }
        if (s.endsWith("\n")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.endsWith("\r")) {
            return s.substring(0, s.length() - 2);
        }
        return s;
    }

    public DelimitedFileReader(String fileName) throws FileNotFoundException, IOException {
        this(fileName, "\t");
    }

    public DelimitedFileReader(String fileName, String delimiter) throws FileNotFoundException, IOException {
        this.delimiter = delimiter;
        BufferedReader fi = new BufferedReader(new FileReader(fileName));
        this.header = DelimitedFileReader.chomp(fi.readLine()).split(delimiter);
        int i = 0;
        while (i < this.header.length) {
            this.column.put(this.header[i], new Integer(i));
            ++i;
        }
        String line = fi.readLine();
        String[] tmpType = DelimitedFileReader.chomp(line).split(delimiter);
        boolean flgOk = true;
        int i2 = 0;
        while (i2 < tmpType.length) {
            if (!(tmpType[i2].equals("string") || tmpType[i2].equals("integer") || tmpType[i2].equals("float") || tmpType[i2].equals("double"))) {
                flgOk = false;
                break;
            }
            ++i2;
        }
        if (flgOk) {
            this.type = tmpType;
            line = fi.readLine();
        }
        while (line != null) {
            this.data.add(DelimitedFileReader.chomp(line).split(delimiter));
            line = fi.readLine();
        }
        fi.close();
    }

    public void write(String fileName) throws IOException, FileNotFoundException {
        FileWriter fw = new FileWriter(fileName);
        int i = 0;
        while (i < this.getNrColumns()) {
            fw.write(String.valueOf(this.getHeader(i)) + (i != this.getNrColumns() - 1 ? "\t" : "\n"));
            ++i;
        }
        int r = 0;
        while (r < this.getNrRows()) {
            String str = "";
            int c = 0;
            while (c < this.getNrColumns()) {
                str = String.valueOf(str) + this.getString(r, c) + (c == this.getNrColumns() - 1 ? "\n" : "\t");
                ++c;
            }
            fw.write(str);
            ++r;
        }
        fw.close();
    }
}

