/*
 * Decompiled with CFR 0.152.
 */
package islab.lib;

public class Sorting {
    public static void sort(double[] array, int[] indices) {
        Sorting.sort_makeheap(array, indices);
        Sorting.sort_sortfromheap(array, indices);
    }

    public static void sort_makeheap(double[] array, int[] indices) {
        int i = 0;
        while (i < indices.length) {
            indices[i] = i;
            ++i;
        }
        int j = array.length / 2;
        while (j > 0) {
            Sorting.adjust(array, indices, j, array.length);
            --j;
        }
    }

    public static void sort_sortfromheap(double[] array, int[] indices) {
        int j = array.length - 1;
        while (j > 0) {
            int temp = indices[0];
            indices[0] = indices[j];
            indices[j] = temp;
            Sorting.adjust(array, indices, 1, j);
            --j;
        }
    }

    public static void bringdown(double[] array, int[] indices) {
        int p1;
        int n = 0;
        while (true) {
            p1 = 2 * (n + 1) - 1;
            int p2 = 2 * (n + 1);
            if (p2 >= array.length) break;
            if (array[indices[n]] < array[indices[p2]] && array[indices[n]] < array[indices[p1]]) {
                return;
            }
            int i = array[indices[p1]] > array[indices[p2]] ? p2 : p1;
            int tmp = indices[i];
            indices[i] = indices[n];
            indices[n] = tmp;
            n = i;
        }
        if (p1 < array.length && array[indices[n]] > array[indices[p1]]) {
            int tmp = indices[p1];
            indices[p1] = indices[n];
            indices[n] = tmp;
        }
    }

    private static void adjust(double[] array, int[] indices, int lower, int upper) {
        int j = lower;
        int k = lower * 2;
        while (k <= upper) {
            if (k < upper && array[indices[k - 1]] > array[indices[k]]) {
                ++k;
            }
            if (array[indices[j - 1]] > array[indices[k - 1]]) {
                int temp = indices[j - 1];
                indices[j - 1] = indices[k - 1];
                indices[k - 1] = temp;
            }
            j = k;
            k *= 2;
        }
    }
}

