/*
 * Decompiled with CFR 0.152.
 */
package islab.lib;

import java.io.File;
import java.io.IOException;
import java.io.StringBufferInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlDomReader {
    public static Document getDocument(File file) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void fatalError(SAXParseException exception) throws SAXException {
                }

                public void error(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                public void warning(SAXParseException err) throws SAXParseException {
                    System.out.println("** Warning, line " + err.getLineNumber() + ", uri " + err.getSystemId());
                    System.out.println("   " + err.getMessage());
                }
            });
            document = builder.parse(file);
            return document;
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    public static Document getDocument(String xmlString) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void fatalError(SAXParseException exception) throws SAXException {
                }

                public void error(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                public void warning(SAXParseException err) throws SAXParseException {
                    System.out.println("** Warning, line " + err.getLineNumber() + ", uri " + err.getSystemId());
                    System.out.println("   " + err.getMessage());
                }
            });
            document = builder.parse(new StringBufferInputStream(xmlString));
            return document;
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    private static void prnt(String s) {
        System.out.print(s);
    }

    private static void prntln(String s) {
        System.out.println(s);
    }

    public static void printXmlNode(Node n, int indentLevel) {
        String indent = "";
        int i = 0;
        while (i < indentLevel) {
            indent = String.valueOf(indent) + "  ";
            ++i;
        }
        if (n.getNodeType() == 3) {
            if (n.getNodeValue() != null && !n.getNodeValue().equals("") && !n.getNodeValue().startsWith("\n")) {
                XmlDomReader.prntln(String.valueOf(indent) + "  " + n.getNodeValue());
            }
        } else {
            int i2;
            XmlDomReader.prnt(String.valueOf(indent) + "<" + n.getNodeName());
            if (n.hasAttributes()) {
                NamedNodeMap atts = n.getAttributes();
                i2 = 0;
                while (i2 < atts.getLength()) {
                    Node a = atts.item(i2);
                    XmlDomReader.prnt(" " + a.getNodeName() + "=");
                    XmlDomReader.prnt(String.valueOf('\"') + a.getNodeValue() + '\"');
                    ++i2;
                }
            }
            XmlDomReader.prntln(">");
            if (n.hasChildNodes()) {
                NodeList l = n.getChildNodes();
                i2 = 0;
                while (i2 < l.getLength()) {
                    XmlDomReader.printXmlNode(l.item(i2), indentLevel + 1);
                    ++i2;
                }
            }
            XmlDomReader.prntln(String.valueOf(indent) + "</" + n.getNodeName() + ">");
        }
    }
}

