/*
 * Decompiled with CFR 0.152.
 */
package islab.lib;

import islab.lib.XmlXomReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import nu.xom.Element;

public class XmlHelper {
    public static final String tag(String tag, int value) {
        return "<" + tag + ">" + value + "</" + tag + ">";
    }

    public static final String tag(String tag, double value) {
        return "<" + tag + ">" + value + "</" + tag + ">";
    }

    public static final String tag(String tag, boolean value) {
        return "<" + tag + ">" + value + "</" + tag + ">";
    }

    public static final String tag(String tag, String value) {
        return "<" + tag + ">" + value + "</" + tag + ">";
    }

    public static final int getInt(Element element, String tag) {
        return XmlHelper.getInt(element, tag, 0);
    }

    public static final int getInt(Element element, String tag, int index) {
        return Integer.parseInt(element.getChildElements(tag).get(index).getValue());
    }

    public static final double getDouble(Element element, String tag) {
        return XmlHelper.getDouble(element, tag, 0);
    }

    public static final double getDouble(Element element, String tag, int index) {
        return Double.parseDouble(element.getChildElements(tag).get(index).getValue());
    }

    public static void saveToFile(String fileName, String str) throws IOException {
        File f = new File(fileName);
        if (!f.exists()) {
            if (f.getParent() != null) {
                new File(f.getParent()).mkdirs();
            }
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f);
        fw.write(str);
        fw.close();
    }

    public static String readFile(String fileName) {
        return XmlXomReader.getDocument(new File(fileName)).toXML();
    }
}

