/*
 * Decompiled with CFR 0.152.
 */
package islab.lib;

import java.io.File;
import java.io.IOException;
import java.io.StringBufferInputStream;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Text;
import nu.xom.ValidityException;

public class XmlXomReader {
    public static Document getDocument(File file) {
        boolean validating = false;
        try {
            Builder builder = validating ? new Builder(true) : new Builder();
            Document doc = builder.build(file);
            return doc;
        }
        catch (ValidityException ex) {
            XmlXomReader.prntln("Error validating file: " + file + "\n" + ex.getMessage());
            return null;
        }
        catch (ParsingException ex) {
            XmlXomReader.prntln("Error parsing file: " + file + "\n" + ex.getMessage());
            return null;
        }
        catch (IOException ex) {
            XmlXomReader.prntln("IO Exception reading file: " + file + "\n" + ex.getMessage());
            return null;
        }
    }

    public static Document getDocument(String xmlString) {
        boolean validating = false;
        try {
            Builder builder = validating ? new Builder(true) : new Builder();
            Document doc = builder.build(new StringBufferInputStream(xmlString));
            return doc;
        }
        catch (ValidityException ex) {
            return null;
        }
        catch (ParsingException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static void prnt(String s) {
        System.out.print(s);
    }

    private static void prntln(String s) {
        System.out.println(s);
    }

    public static void printXmlElement(Element element, int indentLevel) {
        String indent = "";
        int i = 0;
        while (i < indentLevel) {
            indent = String.valueOf(indent) + "  ";
            ++i;
        }
        XmlXomReader.prnt(String.valueOf(indent) + "<" + element.getLocalName());
        i = 0;
        while (i < element.getAttributeCount()) {
            Attribute attr = element.getAttribute(i);
            XmlXomReader.prnt(" " + attr.getLocalName() + "='" + attr.getValue() + "'");
            ++i;
        }
        XmlXomReader.prnt(">");
        if (element.getChildCount() > 0) {
            XmlXomReader.prntln("");
        }
        i = 0;
        while (i < element.getChildCount()) {
            Node node = element.getChild(i);
            if (node instanceof Text) {
                String text = node.getValue();
                if (text.length() > 30) {
                    XmlXomReader.prnt(String.valueOf(indent) + "  |" + text.substring(0, 30) + "...\n");
                }
            } else if (node instanceof Element) {
                XmlXomReader.printXmlElement((Element)node, indentLevel + 1);
            }
            ++i;
        }
        if (element.getChildCount() > 0) {
            XmlXomReader.prnt(indent);
        }
        XmlXomReader.prntln("</" + element.getLocalName() + ">");
    }
}

