/*
 * Decompiled with CFR 0.152.
 */
package islab.util;

import cern.jet.random.engine.RandomEngine;
import islab.util.SeqUtil;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteUniform {
    private RandomEngine randomGenerator;
    private int min;
    private int max;
    private int nBins;
    private double pmf;

    public DiscreteUniform(int min, int max, RandomEngine randomGenerator) {
        this.randomGenerator = randomGenerator;
        this.setState(min, max);
    }

    public void setState(int min, int max) {
        if (min > max || min < 0 || max < 0) {
            throw new IllegalArgumentException("Cannot instantiate uniform");
        }
        this.min = min;
        this.max = max;
        this.nBins = max - min + 1;
        this.pmf = 1.0 / (double)this.nBins;
    }

    public double cdf(int k) {
        if (k < this.min) {
            return 0.0;
        }
        if (k >= this.max) {
            return 1.0;
        }
        return this.pmf + this.pmf * (double)(k - this.min);
    }

    public double pmf(int k) {
        if (k < this.min) {
            return 0.0;
        }
        if (k > this.max) {
            return 0.0;
        }
        return this.pmf;
    }

    public int nextInt() {
        return this.min + (int)((double)this.nBins * this.randomGenerator.raw());
    }

    public int nextIntFromTo(int min, int max) {
        return min + (int)((double)(max - min + 1) * this.randomGenerator.raw());
    }

    public static int choose(int nrChoices, RandomEngine engine) {
        return DiscreteUniform.choose(0, nrChoices, engine) + 1;
    }

    public static int choose(int lo, int hi, RandomEngine engine) {
        return lo + (int)((double)(hi - lo) * engine.raw());
    }

    public static int chooseExcept(int from, int to, Set<Integer> exceptions, RandomEngine engine) {
        List<Integer> values = SeqUtil.range(from, to);
        values.removeAll(exceptions);
        return values.get(DiscreteUniform.choose(0, values.size(), engine));
    }

    public static int chooseBinary(RandomEngine engine) {
        if (engine.raw() < 0.5) {
            return 0;
        }
        return 1;
    }

    public static <T> T pickOne(T[] array, RandomEngine engine) {
        return array[DiscreteUniform.choose(0, array.length, engine)];
    }

    public static int pickOne(int[] array, RandomEngine engine) {
        return array[DiscreteUniform.choose(0, array.length, engine)];
    }

    public static <T> T pickOne(List<T> list, RandomEngine engine) {
        return list.get(DiscreteUniform.choose(0, list.size(), engine));
    }
}

