/*
 * Decompiled with CFR 0.152.
 */
package islab.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniFileParser {
    private Map<String, String> settings = new HashMap<String, String>();

    public IniFileParser(String fileName) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new FileReader(fileName));
        Pattern p = Pattern.compile("\\s*(\\S+)\\s*=\\s*(.*)");
        while ((line = reader.readLine()) != null) {
            if (line.matches("\\s*#.*") || line.matches("\\s*")) continue;
            Matcher m = p.matcher(line);
            if (m.matches()) {
                String key = m.group(1);
                String value = m.group(2);
                if (this.settings.containsKey(key)) {
                    throw new RuntimeException("Invalid ini-file format, same key defined twice, line nr " + reader.getLineNumber());
                }
                this.settings.put(key, value);
                continue;
            }
            throw new RuntimeException("Invalid ini-file format, line nr " + reader.getLineNumber());
        }
        reader.close();
        System.out.println(this.settings);
    }

    public Boolean parseBooleanValue(String key) {
        if (!this.settings.containsKey(key)) {
            throw new RuntimeException("No key \"" + key + "\" in ini-file");
        }
        return new Boolean(this.settings.get(key));
    }

    public Double parseDoubleValue(String key) {
        if (!this.settings.containsKey(key)) {
            throw new RuntimeException("No key \"" + key + "\" in ini-file");
        }
        try {
            return new Double(this.settings.get(key));
        }
        catch (NumberFormatException e) {
            System.out.println("Number format error: Expected a double value for key " + key + ".");
            System.exit(2);
            return null;
        }
    }

    public Integer parseIntValue(String key) {
        if (!this.settings.containsKey(key)) {
            throw new RuntimeException("No key \"" + key + "\" in ini-file");
        }
        try {
            return new Integer(this.settings.get(key));
        }
        catch (NumberFormatException e) {
            System.out.println("Number format error: Expected an integer value for key " + key + ".");
            System.exit(2);
            return null;
        }
    }

    public String parseStringValue(String key) {
        if (!this.settings.containsKey(key)) {
            throw new RuntimeException("No key \"" + key + "\" in ini-file");
        }
        return this.settings.get(key);
    }

    public <T extends Enum<T>> T parseEnumValue(Class<T> enumType, String key) {
        if (!this.settings.containsKey(key)) {
            throw new RuntimeException("No key \"" + key + "\" in ini-file");
        }
        return Enum.valueOf(enumType, this.settings.get(key));
    }

    public <T> T parseValue(String key, Class<T> cl) {
        try {
            Constructor<T> c = cl.getConstructor(String.class);
            if (!this.settings.containsKey(key)) {
                throw new RuntimeException("No key \"" + key + "\" in ini-file");
            }
            return c.newInstance(this.settings.get(key));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }
}

