/*
 * Decompiled with CFR 0.152.
 */
package islab.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqUtil {
    static final Map<Class, Class> WRAPPERS = new HashMap<Class, Class>();

    static {
        WRAPPERS.put(Byte.TYPE, Byte.class);
        WRAPPERS.put(Short.TYPE, Short.class);
        WRAPPERS.put(Character.TYPE, Character.class);
        WRAPPERS.put(Integer.TYPE, Integer.class);
        WRAPPERS.put(Long.TYPE, Long.class);
        WRAPPERS.put(Float.TYPE, Float.class);
        WRAPPERS.put(Double.TYPE, Double.class);
        WRAPPERS.put(Boolean.TYPE, Boolean.class);
    }

    public static boolean allTrue(Iterable<Boolean> seq) {
        for (Boolean b : seq) {
            if (b.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static double median(Collection<Integer> seq) {
        int n = seq.size();
        if (n == 0) {
            throw new IllegalArgumentException("empty array");
        }
        if (n == 1) {
            return seq.iterator().next().intValue();
        }
        int[] tmp = new int[n];
        int i = 0;
        for (int j : seq) {
            tmp[i++] = j;
        }
        Arrays.sort(tmp);
        if (n % 2 == 0) {
            return (double)(tmp[n / 2] + tmp[n / 2 - 1]) / 2.0;
        }
        return tmp[(n - 1) / 2];
    }

    public static ArrayList mapMethod(String method, Iterable sequence, Object ... args) {
        ArrayList<Object> a = new ArrayList<Object>();
        Class[] parameterTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        for (Object object : sequence) {
            try {
                Method m = object.getClass().getMethod(method, parameterTypes);
                try {
                    a.add(m.invoke(object, args));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return a;
    }

    public static <T> T[] mapMethod(String method, Object[] array, Object ... args) {
        try {
            Class[] parameterTypes = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                parameterTypes[i] = args[i].getClass();
                ++i;
            }
            Method m = array.getClass().getComponentType().getMethod(method, parameterTypes);
            Class returnType = m.getReturnType();
            if (returnType.isPrimitive()) {
                returnType = WRAPPERS.get(returnType);
            }
            Object[] a = (Object[])Array.newInstance(returnType, array.length);
            int i2 = 0;
            while (i2 < array.length) {
                try {
                    a[i2] = m.invoke(array[i2], args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i2;
            }
            return a;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Integer> range(int from, int to) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        int i = from;
        while (i <= to) {
            l.add(i);
            ++i;
        }
        return l;
    }

    public static List<Double> doubleRange(double from, double to, double increment) {
        ArrayList<Double> l = new ArrayList<Double>();
        double i = from;
        while (i <= to) {
            l.add(i);
            i += increment;
        }
        return l;
    }

    public static void main(String[] args) {
        System.out.println(SeqUtil.doubleRange(0.0, 0.5, 0.1));
    }
}

