/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UTFDataFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import nu.xom.Document;
import nu.xom.NodeFactory;
import nu.xom.NonVerifyingFactory;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import nu.xom.XML1_0Parser;
import nu.xom.XMLException;
import nu.xom.XOMHandler;
import org.apache.xerces.impl.Version;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Builder {
    private XMLReader parser;
    private NodeFactory factory;
    private static double xercesVersion;
    private static String[] parsers;
    private static String fileURLPrefix;
    private static boolean isWindows;

    public Builder() {
        this(false);
    }

    public Builder(boolean bl) {
        this(Builder.findParser(bl), bl, null);
    }

    public Builder(boolean bl, NodeFactory nodeFactory) {
        this(Builder.findParser(bl), bl, nodeFactory);
    }

    private static XMLReader findParser(boolean bl) {
        try {
            XML1_0Parser xML1_0Parser = new XML1_0Parser();
            Builder.setupParser((XMLReader)((Object)xML1_0Parser), bl);
            return xML1_0Parser;
        }
        catch (SAXException sAXException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        for (int i = 1; i < parsers.length; ++i) {
            try {
                XMLReader xMLReader = XMLReaderFactory.createXMLReader(parsers[i]);
                Builder.setupParser(xMLReader, bl);
                return xMLReader;
            }
            catch (SAXException sAXException) {
                continue;
            }
        }
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            Builder.setupParser(xMLReader, bl);
            return xMLReader;
        }
        catch (SAXException sAXException) {
            throw new XMLException("Could not find a suitable SAX2 parser", sAXException);
        }
    }

    private static void setupParser(XMLReader xMLReader, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!bl) {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            if (xMLReader.getClass().getName().equals("org.apache.crimson.parser.XMLReaderImpl")) {
                xMLReader.setErrorHandler(new NamespaceWellformednessRequired());
            } else {
                xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", true);
                xMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
            }
        } else {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            xMLReader.setErrorHandler(new ValidityRequired());
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/string-interning", true);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        if (xMLReader.getClass().getName().equals("nu.xom.XML1_0Parser") || xMLReader.getClass().getName().equals("org.apache.xerces.parsers.SAXParser")) {
            try {
                xMLReader.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            try {
                xMLReader.setFeature("http://apache.org/xml/features/standard-uri-conformant", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    public Builder(XMLReader xMLReader) {
        this(xMLReader, false);
    }

    public Builder(NodeFactory nodeFactory) {
        this(Builder.findParser(false), false, nodeFactory);
    }

    public Builder(XMLReader xMLReader, boolean bl) {
        this(xMLReader, bl, null);
    }

    public Builder(XMLReader xMLReader, boolean bl, NodeFactory nodeFactory) {
        try {
            Builder.setupParser(xMLReader, bl);
        }
        catch (SAXException sAXException) {
            if (bl) {
                throw new XMLException(xMLReader.getClass().getName() + " does not support validation.", sAXException);
            }
            throw new XMLException(xMLReader.getClass().getName() + " does not support the entity resolution" + " features XOM requires.", sAXException);
        }
        this.parser = xMLReader;
        if (nodeFactory != null) {
            this.setHandlers(nodeFactory);
        } else if (Builder.knownGoodParser(xMLReader)) {
            this.setHandlers(new NonVerifyingFactory());
        } else {
            this.setHandlers(new NodeFactory());
        }
    }

    private static boolean knownGoodParser(XMLReader xMLReader) {
        String string = xMLReader.getClass().getName();
        if (string.equals("org.apache.xml.resolver.tools.ResolvingXMLReader") || string.equals("org.apache.xml.resolver.tools.ResolvingXMLFilter")) {
            XMLFilter xMLFilter = (XMLFilter)xMLReader;
            string = xMLFilter.getParent().getClass().getName();
        }
        if (string.equals("gnu.xml.aelfred2.XmlReader")) {
            return false;
        }
        if (string.equals("net.sf.saxon.aelfred.SAXDriver")) {
            return false;
        }
        if (string.equals("org.apache.xerces.parsers.SAXParser") && xercesVersion >= 2.4) {
            return false;
        }
        for (int i = 0; i < parsers.length; ++i) {
            if (!string.equals(parsers[i])) continue;
            return true;
        }
        return false;
    }

    private void setHandlers(NodeFactory nodeFactory) {
        this.factory = nodeFactory;
        XOMHandler xOMHandler = new XOMHandler(nodeFactory);
        this.parser.setContentHandler(xOMHandler);
        this.parser.setDTDHandler(xOMHandler);
        try {
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", xOMHandler);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            this.parser.setProperty("http://xml.org/sax/properties/declaration-handler", xOMHandler);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public Document build(String string) throws ParsingException, ValidityException, IOException {
        string = this.canonicalizeURL(string);
        InputSource inputSource = new InputSource(string);
        return this.build(inputSource);
    }

    public Document build(InputStream inputStream) throws ParsingException, ValidityException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        return this.build(inputSource);
    }

    public Document build(InputStream inputStream, String string) throws ParsingException, ValidityException, IOException {
        string = this.canonicalizeURL(string);
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.build(inputSource);
    }

    public Document build(File file) throws ParsingException, ValidityException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = file.getAbsolutePath();
        StringBuffer stringBuffer = new StringBuffer(fileURLPrefix);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == File.separatorChar) {
                stringBuffer.append('/');
                continue;
            }
            if (c == ':' && isWindows) {
                stringBuffer.append(':');
                continue;
            }
            stringBuffer.append(URLEncoder.encode(String.valueOf(c)));
        }
        String string2 = stringBuffer.toString();
        return this.build(fileInputStream, string2);
    }

    public Document build(Reader reader) throws ParsingException, ValidityException, IOException {
        InputSource inputSource = new InputSource(reader);
        return this.build(inputSource);
    }

    public Document build(Reader reader, String string) throws ParsingException, ValidityException, IOException {
        string = this.canonicalizeURL(string);
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        return this.build(inputSource);
    }

    public Document build(String string, String string2) throws ParsingException, ValidityException, IOException {
        StringReader stringReader = new StringReader(string);
        return this.build(stringReader, string2);
    }

    private String canonicalizeURL(String string) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getFile();
            if (string2 == null || string2.length() == 0 || "/".equals(string2) && !string.endsWith("/")) {
                string = string + '/';
            }
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    private Document build(InputSource inputSource) throws ParsingException, ValidityException, IOException {
        ValidityRequired validityRequired;
        try {
            this.parser.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            ParsingException parsingException = new ParsingException(sAXParseException.getMessage(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getException());
            throw parsingException;
        }
        catch (SAXException sAXException) {
            ParsingException parsingException = new ParsingException(sAXException.getMessage(), inputSource.getSystemId(), sAXException);
            throw parsingException;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ParsingException parsingException = new ParsingException(arrayIndexOutOfBoundsException.getMessage(), inputSource.getSystemId(), arrayIndexOutOfBoundsException);
            throw parsingException;
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            ParsingException parsingException = new ParsingException(negativeArraySizeException.getMessage(), inputSource.getSystemId(), negativeArraySizeException);
            throw parsingException;
        }
        catch (NullPointerException nullPointerException) {
            ParsingException parsingException = new ParsingException(nullPointerException.getMessage(), inputSource.getSystemId(), nullPointerException);
            throw parsingException;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            ParsingException parsingException = new ParsingException(uTFDataFormatException.getMessage(), inputSource.getSystemId(), uTFDataFormatException);
            throw parsingException;
        }
        catch (CharConversionException charConversionException) {
            ParsingException parsingException = new ParsingException(charConversionException.getMessage(), inputSource.getSystemId(), charConversionException);
            throw parsingException;
        }
        catch (IOException iOException) {
            if (iOException.getClass().getName().equals("org.apache.xerces.util.URI$MalformedURIException")) {
                throw new ParsingException(iOException.getMessage(), inputSource.getSystemId(), iOException);
            }
            throw iOException;
        }
        XOMHandler xOMHandler = (XOMHandler)this.parser.getContentHandler();
        ErrorHandler errorHandler = this.parser.getErrorHandler();
        Document document = xOMHandler.getDocument();
        if (errorHandler instanceof ValidityRequired && !(validityRequired = (ValidityRequired)errorHandler).isValid()) {
            ValidityException validityException = validityRequired.vexception;
            validityException.setDocument(document);
            validityRequired.reset();
            throw validityException;
        }
        return document;
    }

    public NodeFactory getNodeFactory() {
        if (this.factory instanceof NonVerifyingFactory) {
            return null;
        }
        return this.factory;
    }

    static {
        String string;
        xercesVersion = 2.6;
        try {
            string = Version.getVersion();
            string = string.substring(9, 12);
            xercesVersion = Double.valueOf(string);
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        parsers = new String[]{"nu.xom.XML1_0Parser", "org.apache.xerces.parsers.SAXParser", "gnu.xml.aelfred2.XmlReader", "org.apache.crimson.parser.XMLReaderImpl", "com.bluecast.xml.Piccolo", "oracle.xml.parser.v2.SAXParser", "com.jclark.xml.sax.SAX2Driver", "net.sf.saxon.aelfred.SAXDriver", "com.icl.saxon.aelfred.SAXDriver", "org.dom4j.io.aelfred.SAXDriver"};
        fileURLPrefix = "file://";
        isWindows = false;
        string = System.getProperty("os.name", "Unix");
        if (string.indexOf("Windows") >= 0) {
            fileURLPrefix = "file:/";
            isWindows = true;
        }
    }

    private static class NamespaceWellformednessRequired
    implements ErrorHandler {
        private NamespaceWellformednessRequired() {
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void error(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }
    }

    private static class ValidityRequired
    implements ErrorHandler {
        ValidityException vexception = null;

        private ValidityRequired() {
        }

        void reset() {
            this.vexception = null;
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void error(SAXParseException sAXParseException) {
            if (this.vexception == null) {
                this.vexception = new ValidityException(sAXParseException.getMessage(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException);
            }
            this.vexception.addError(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }

        boolean isValid() {
            return this.vexception == null;
        }
    }
}

