/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xslt;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.XMLException;
import nu.xom.xslt.XOMResult;
import nu.xom.xslt.XOMSource;
import nu.xom.xslt.XSLException;
import org.xml.sax.SAXParseException;

public final class XSLTransform {
    private Templates templates;
    private NodeFactory factory = new NodeFactory();

    private XSLTransform(Source source) throws XSLException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.templates = transformerFactory.newTemplates(source);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new XSLException("Could not locate a TrAX TransformerFactory", transformerFactoryConfigurationError);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XSLException("Syntax error in stylesheet", transformerConfigurationException);
        }
    }

    public XSLTransform(InputStream inputStream) throws XSLException {
        this(new StreamSource(inputStream));
    }

    public XSLTransform(Reader reader) throws XSLException {
        this(new StreamSource(reader));
    }

    public XSLTransform(File file) throws XSLException {
        this(new StreamSource(file));
    }

    public XSLTransform(Document document) throws XSLException {
        this(new XOMSource(document));
    }

    public XSLTransform(String string) throws XSLException {
        this(new StreamSource(string));
    }

    public Nodes transform(Document document) throws XSLException {
        return this.transform(new XOMSource(document));
    }

    public Nodes transform(Nodes nodes) throws XSLException {
        if (nodes.size() == 0) {
            return new Nodes();
        }
        return this.transform(new XOMSource(nodes));
    }

    private Nodes transform(Source source) throws XSLException {
        try {
            XOMResult xOMResult = new XOMResult(this.factory);
            Transformer transformer = this.templates.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.transform(source, xOMResult);
            return xOMResult.getResult();
        }
        catch (Exception exception) {
            TransformerException transformerException;
            Throwable throwable;
            Throwable throwable2 = exception;
            if (throwable2 instanceof TransformerException && (throwable = (transformerException = (TransformerException)throwable2).getException()) != null && (throwable2 = throwable) instanceof SAXParseException && (throwable = ((SAXParseException)throwable2).getException()) != null) {
                throwable2 = throwable;
            }
            exception.printStackTrace();
            throw new XSLException(exception.getMessage(), throwable2);
        }
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.factory = nodeFactory == null ? new NodeFactory() : nodeFactory;
    }

    public static Document toDocument(Nodes nodes) {
        int n;
        Element element = null;
        int n2 = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            if (!(nodes.get(i) instanceof Element)) continue;
            n2 = i;
            element = (Element)nodes.get(i);
            break;
        }
        if (element == null) {
            throw new XMLException("No root element");
        }
        Document document = new Document(element);
        for (n = 0; n < n2; ++n) {
            document.insertChild(nodes.get(n), n);
        }
        for (n = n2 + 1; n < nodes.size(); ++n) {
            document.appendChild(nodes.get(n));
        }
        return document;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": " + this.templates + "]";
    }
}

