# Instructions for running the experiments

## Preamble

In order to correctly launch the scripts, please first run the `pip install -e .` command from the current location (`iclr2025_code/.`).

## Synthetic data generation

Run the `./exps/data/generate_dataset.py` script with such commands to generate training and testing sets in the weakly sparse and strongly sparse settings:

```
python generate_dataset.py -set_type train -n 100 -p 20 -den 0.95 -size 10000 -as_tensor 1 -random_state 0 -same_Theta_true 0 ;
```
```
python generate_dataset.py -set_type test -n 100 -p 20 -den 0.95 -size 10000 -as_tensor 1 -random_state 1 -same_Theta_true 0 ;
```

## Models

Every `PyTorch` classes related to `SpodNet` layers are contained in the `./models/` folder.

* `./spodnet/models/framework.py` contains the main `SpodNet` class, which is the generic layer performing various possible updates to create the `UBG`, `PNP` or `E2E` architectures (specified during initialization of the class).

* `./spodnet/models/perturbation_layers.py` contains the classes implementing the three models' different update rules.

## Experiments

The script for training the different models on various datasets is in `./exps/train_spodnet.py`, with the desired setting that can be specified in arguments when launching the script.
After running the two above lines to generate train and test datasets, a typical command to do so is for example:

```
python train_spodnet.py -train_samples 1000 -test_samples 100 -n 100 -p 20 -train_batch_size 10 -test_batch_size 100 -precision_sparsity 0.95 -K 1 -epochs 100 -lr 1e-2 -learning_mode 'UBG'
```

Upon training, the script to plot the convergence of NMSEs for different methods in various settings is in `./exps/NMSE_convergence.py`

A script to compute the traditional methods' performance (GLasso, Ledoit-Wolf and OAS) is in `./exps/fit_traditional_methods.py`.

A script to train GLAD (which we retrieved and adapted from the original GitHub repo `https://github.com/Harshs27/GLAD`) are in `./exps/train_glad.py`.






