# latent-causal-cf

Welcome! This is the anonymous repo for the work: "Towards Characterizing Domain Counterfactuals
for Invertible Latent Causal Models".

To recreate the results for the experiment, first create the necessary python environment. This can be done with conda by 
`conda env create -f environment.yml`.

The experiments can all be run and tracked via [Weights And Biases](https://wandb.ai/).

## Recreating experiments with Weights And Biases
We can utilize the Weights And Biases sweep functionality to create a sweep for all of our experiments.

Below we use the RMNIST experiments as an example. 

For anonymization we remove the `entity` in the config files which should be replaced by your own wandb entity.

To recreate the RMNIST experiments, please first traverse to the directory 
```$ cd rmnist```, then run the following command to create the Weights And Biases sweep (If you are not logged into `wandb` you will have to log in and re-run this command):

```$ wandb sweep configs/iclr_rmnist.yaml```

This should print a command which you can use to run a wandb agent (e.g., `wandb agent "xxx/ICLR2024-RMNIST/yyy"`).
To begin running experiments you can just enter the wandb agent command and this should begin automatically creating and tracking
all the simulated experiments.

Then do the same thing for 

```$ wandb sweep configs/iclr_rmnist_p2.yaml```

We created two config files because we don't need to run experiments with different ``k`` for ILD-Dense and ILD-Independent.

### Without wandb

Instead of using wandb, you can also run each experiment individually by running the corresponding python script. For example,
```angular2html
python main.py --no_wandb --k_spa 2 --latent_dim 20 --model_preset '1' --num_iters 300000
```
This will train ILD-Relax-Can with m=20 and k=2.
Here model preset 1 represents ILD-Relax-Can, 3 represents ILD-Dense, 4 represents ILD-Independent.
Note that `k_spa` does not affect ILD-Dense and ILD-Independent.
For simulated experiments, an example would be 
```angular2html
python main.py --no_wandb --k_spa 2 --latent_dim 6 --int_set '4,5' --f_type 'autp_true_spa' --n_domains 3
```
Here 'auto_true_spa' represents ILD-Relax-Can and 'auto_full' represents ILD-Dense. `intset` specifies the intervention set of the 
ground truth dataset. Our model is designed to have intervention set at the last few nodes. `scm_idx` is an useless parameter in the current version.

## Reproducibility

To reproduce all results for each experiment, you can just finish all the sweep in the `<dataset>/configs` folder. For simulated experiments, 
because of the large amount of different configs, we put them in just one config file. You would need to uncomment the corresponding experiment and 
sweep over it accordingly.

For 3D Shapes, you need subsample the original dataset by choosing one scale and save the files at the corresponding directory.

For image-based experiments, you need to run the script below to get result with our classifier-based metrics.

```angular2html
python test_counterfactual_model.py --dataset <dataset-name>
```