import numpy as np
import random
import time


def generate_ieee16_grid(n_loads, n_generators, g, topology_seed, branching_factor):
    # Read config

    feeder_inds = [0, 1, 2]
    pv_inds = [16, 17, 18, 19, 20, 21]
    load_inds = []
    ev_charger_inds = [3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
    connections = [(0, 3), (3, 4), (3, 5), (5, 6), (1, 7), (7, 8), (7, 9), (8, 10), (8, 11),
                   (2, 12), (12, 13), (12, 14), (14, 15), (5, 16), (4, 17), (8, 18), (9, 19), (11, 20),
                   (14, 21), (4, 10), (9, 13), (6, 15)]
    loads_regions = [[0], [1], [2]] + [[3, 4, 5, 6], [7, 8, 9, 10, 11], [12, 13, 14, 15]] + [[i] for i in dg_inds]
    connected_nodes = [(0, 3), (3, 4), (3, 5), (5, 6), (1, 7), (7, 8), (7, 9), (8, 10), (8, 11),
                       (2, 12), (12, 13), (12, 14), (14, 15), (5, 16), (4, 17), (8, 18), (9, 19), (11, 20), (14, 21)]
    n_nodes = n_loads + n_generators
    node_inds = np.arange(0, n_nodes)
    generator_inds = [0] + np.random.choice(node_inds[2:], size=n_generators-1, replace=False).tolist()
    load_inds = [1] + [ind for ind in node_inds if ind not in generator_inds]
    processed_device_indices = []
    connections = []
    # np.random.shuffle(node_inds)
    for ind in node_inds:
        inds_to_choose_from = processed_device_indices
        if ind in generator_inds:
            inds_to_choose_from = [ind for ind in processed_device_indices if ind not in generator_inds]
        if len(processed_device_indices) != 0:
            if np.random.uniform() >= branching_factor:
                ind_from = inds_to_choose_from[-1]
            else:
                ind_from = np.random.choice(inds_to_choose_from)
            connections.append((ind_from, ind))
        processed_device_indices.append(ind)

    if topology_seed is not None:
        np.random.seed(int(1000 * time.time()) % 2 ** 32)
    # Create topology
    conductance_matrix = np.zeros((n_nodes, n_nodes))
    for i_from, i_to in connections:
        conductance_matrix[i_from, i_to] = g
        conductance_matrix[i_to, i_from] = g
    return generator_inds, load_inds, conductance_matrix

