# Installation
1. `conda create -n diffopt python=3.8`
2. `conda activate diffopt`
3. `conda install jupyter`
4. `conda install nb_conda_kernels`
5. `pip install -r requirements.txt` (this will install cpu version of torch, refer to the official documentation for the GPU support)

# Usage
For the portfolio optimization problem, you should apply for a Quandl API key from [Quandl](https://docs.data.nasdaq.com/docs#section-authentication). 
Once you have got your API key, save it in the
_src/portfolio_optimization/quandl_key.py_ 
by adding a line `key="your_api_key"`.
When a portfolio optimization problem experiment is ran for the first time,
the data will be downloaded automatically, though this process 
might take some time (in our case, 20-30 minutes).

Both the portfolio optimization problem and the OPF problem experiments follow the same pipeline.
1. Create experiments with _notebooks/problem/1.Save run configs.ipynb_
2. Run created experiments with _notebooks/problem/2.Run experiment.ipynb_
3. Visualize the results with _notebooks/problem/3.Make plots.ipynb_