

class Predictor:

    def __init__(self,
                 n_variables: int,
                 observation_size: int,
                 predict_x_u: bool = False,
                 init_seed: int = None,
                 **kwargs):

        self.train_W_sq = False
        self.observation_size = observation_size
        self.n_variables = n_variables
        self.init_seed = init_seed
        self.predict_x_u = predict_x_u
        self.parameters = []

    def predict(self, obs) -> dict:
        raise NotImplementedError

    def create_copy(self):
        raise NotImplementedError

    def save(self, path):
        raise NotImplementedError

    def load(self, path):
        raise NotImplementedError

    def post_epoch_routine(self):
        pass
