import numpy as np
import random
import time


def generate_random_grid(n_loads, n_generators, g, topology_seed, branching_factor):
    # Read config

    topology_seed = topology_seed
    branching_factor = branching_factor
    if topology_seed is not None:
        np.random.seed(topology_seed)
    n_nodes = n_loads + n_generators
    node_inds = np.arange(0, n_nodes)
    generator_inds = [0] + np.random.choice(node_inds[2:], size=n_generators-1, replace=False).tolist()
    load_inds = [1] + [ind for ind in node_inds if ind not in generator_inds]
    processed_device_indices = []
    connections = []
    # np.random.shuffle(node_inds)
    for ind in node_inds:
        inds_to_choose_from = processed_device_indices
        if ind in generator_inds:
            inds_to_choose_from = [ind for ind in processed_device_indices if ind not in generator_inds]
        if len(processed_device_indices) != 0:
            if np.random.uniform() >= branching_factor:
                ind_from = inds_to_choose_from[-1]
            else:
                ind_from = np.random.choice(inds_to_choose_from)
            connections.append((ind_from, ind))
        processed_device_indices.append(ind)

    if topology_seed is not None:
        np.random.seed(int(1000 * time.time()) % 2 ** 32)
    # Create topology
    conductance_matrix = np.zeros((n_nodes, n_nodes))
    for i_from, i_to in connections:
        conductance_matrix[i_from, i_to] = g
        conductance_matrix[i_to, i_from] = g
    return generator_inds, load_inds, conductance_matrix

