import igraph


def _make_graph(generator_inds, n_nodes, conductance_matrix):
    gen_color = 'red'
    load_color = 'purple'
    graph = igraph.Graph()
    for ind in range(n_nodes):
        if ind in generator_inds:
            name = 'gen%d' % ind
            c = gen_color
            s = 12
            shape = 'triangle-down'
            label_size = 10
        else:
            name = 'load%d' % ind
            c = load_color
            s = 8
            shape = 'square'
            label_size = 15

        graph.add_vertex(str(ind), color=c, size=s, label=name, shape=shape,
                         label_dist=2, label_size=label_size, )
    for node_from in range(n_nodes):
        for node_to in range(node_from, n_nodes):
            if conductance_matrix[node_from, node_to] > 0:
                graph.add_edge(str(node_from), str(node_to), )
    return graph
