Make sure you have 64 GB RAM, then:

1. Create a new Python environment by following requirements.txt.
2. Download sehstr_gbtr_allpreds.pkl by running
   wget https://osf.io/download/6828ee2c0476cb6f58f07ea8/?view_only=3763b4606c6f475aaf72753c71dafb1d -O sehstr_gbtr_allpreds.pkl

   copy sehstr_gbtr_allpreds.pkl to code/gym_envs/sehstr/, as this a file necessary for moelcule generation environments.

3. For a simple validation of certain environment, one can run
   python train.py -s [environment_name] -m [model] -t [total_training_steps] --batch_size [batch_size] -sm [sampling_method] --nn_hidden_sizes [hidden_units] --train_freq [training_frequency] --activation [activation_function] -lr [learning_rate]
   -nvs [number_of_validation_samples] --te [initial_temperature] -tr [temperature_decay_rate] --seed [random_seed] [-p] [-uf] [-d]
   -fu [batch_filter_upper_threshold] -er [initial_probability_for_epsilon_random_action]

   e.g.,
   python train.py -s hypergrid-mild -m gfn -t 200000 --batch_size 16 -sm 3 --nn_hidden_sizes 256 256 --train_freq 16 --activation leakyr -lr 0.005 -iz 0.1 -nvs 200000 -te 0.01 --seed 42 -p -uf -fu 3.0 -er 0.0 -tr 10 -d

   this will start a training for 64x64 hypergrid with l1 error reported from the offline data, more details of the parameters are available in code/train.py.

4. To reproduce our experiments, run
   bash train_full.sh
   After finished, rename the output folder as output_full
5. run (for sensitivity analysis)
   bash train_supp.sh
   After finished, rename the output folder as output_supp
6. run (for ablation study)
   bash train_ablation.sh
   After finished, rename the output folder as output_ablation
7. For the performance metrics, run obtain_performance.py --input_dir [output_full/ablation] --mode [full/ablation]. For the multi-objective pusher environment results in Figure 2, run python obtain_pusher_diversity.py. For ablation table, run obtain_performance_from_replay.py (note you need to modify the environment name inside the file)
8. Finally, go to the code/notebooks folder. run results_visualization.ipynb and results_sensitivity.ipynb to visualize the results.
