#!/bin/bash
cd code
if [ $? -ne 0 ]; then
  echo "Failed to change directory to code"
  exit 1
fi

TIMESTAMP=$(date '+%Y%m%d_%H%M%S')


environment="hypergrid-mild"
activation_layer="leakyr"
total_step="20000"

learning_rate="0.005"
batch_size="16"

for seed in 470 3825 4444 8888 9528
do
  name="${environment}_${seed}_${sampling}_${temperature}"
  outputfile="logs/${name}.out"
  echo "queueing ${name}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
		 -t ${total_step} -lr ${learning_rate}  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 --batch_size ${batch_size} -tr 10

  name2="${environment}_${seed}_${sampling}_${temperature}_usefilter"
  outputfile="logs/${name2}.out"
  echo "queueing ${name2}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
		 -t ${total_step} -lr ${learning_rate}  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 3 -te 0.01 \
		 -uf --batch_size ${batch_size} -fu 3 -fl 1 -tr 10
  
  name3="${environment}_${seed}_gafn"
  outputfile="logs/${name3}.out"
  echo "queueing ${name3}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gafn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr ${learning_rate}  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 --batch_size ${batch_size}

  name4="${environment}_${seed}_pbgfn"
  outputfile="logs/${name4}.out"
  echo "queueing ${name4}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr ${learning_rate}  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 \
		 -pu 8 --batch_size ${batch_size}
  
  name5="${environment}_${seed}_vanillagfn"
  outputfile="logs/${name5}.out"
  echo "queueing ${name5}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr ${learning_rate}  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 0 -te 0 --batch_size ${batch_size}
		 
  name6="${environment}_${seed}_gfnsub"
  outputfile="logs/${name6}.out"
  echo "queueing ${name6}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfnsub -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr ${learning_rate}  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 --batch_size ${batch_size}
		 
  name7="${environment}_${seed}_gafn"
  outputfile="logs/${name7}.out"
  echo "queueing ${name7}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m teacher -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr ${learning_rate}  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 --batch_size ${batch_size}
  
done

environment="hypergrid-hard"
activation_layer="leakyr"
total_step="20000"
batch_size="16"

for seed in 470 3825 4444 8888 9528 
do
  name="${environment}_${seed}_${sampling}_${temperature}"
  outputfile="logs/${name}.out"
  echo "queueing ${name}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
		 -t ${total_step} -lr 0.0001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 --batch_size ${batch_size} -tr 10

  name2="${environment}_${seed}_${sampling}_${temperature}_usefilter"
  outputfile="logs/${name2}.out"
  echo "queueing ${name2}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
		 -t ${total_step} -lr 0.0001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 3 -te 0.01 \
		 -uf --batch_size ${batch_size}  -fu 3 -fl 1 -tr 10
  
  name3="${environment}_${seed}_gafn"
  outputfile="logs/${name3}.out"
  echo "queueing ${name3}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gafn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.0001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 --batch_size ${batch_size}

  name4="${environment}_${seed}_pbgfn"
  outputfile="logs/${name4}.out"
  echo "queueing ${name4}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.0001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 \  
		 -pu 8 --batch_size ${batch_size}
  
  name5="${environment}_${seed}_vanillagfn"
  outputfile="logs/${name5}.out"
  echo "queueing ${name5}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.0001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 0 -te 0 --batch_size ${batch_size}

  name6="${environment}_${seed}_gfnsub"
  outputfile="logs/${name6}.out"
  echo "queueing ${name6}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfnsub -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.0001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 --batch_size ${batch_size}
		 
  name7="${environment}_${seed}_teacher"
  outputfile="logs/${name7}.out"
  echo "queueing ${name7}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m teacher -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.0001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 --batch_size ${batch_size}
  
done


environment="molecular-generation"
activation_layer="leakyr"
total_step="30000"
batch_size="16"

for seed in 470 3825 4444 8888 9528
do
  name="${environment}_${seed}_${sampling}_${temperature}"
  outputfile="logs/${name}.out"
  echo "queueing ${name}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
		 -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 --batch_size ${batch_size} -er 0.1

  name2="${environment}_${seed}_${sampling}_${temperature}_usefilter"
  outputfile="logs/${name2}.out"
  echo "queueing ${name2}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
		 -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 3 -te 0.001 \
		 -uf --batch_size ${batch_size} -fu 1 -fl 2 -er 0.1
  
  name3="${environment}_${seed}_gafn"
  outputfile="logs/${name3}.out"
  echo "queueing ${name3}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gafn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr  0.0001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 --batch_size ${batch_size} -er 0.1

  name4="${environment}_${seed}_pbgfn"
  outputfile="logs/${name4}.out"
  echo "queueing ${name4}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 \
		 -pu 8 --batch_size ${batch_size} -er 0.1
  
  name5="${environment}_${seed}_vanillagfn"
  outputfile="logs/${name5}.out"
  echo "queueing ${name5}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 0 -te 0 --batch_size ${batch_size} -er 0.1
		 
  name6="${environment}_${seed}_subtb"
  outputfile="logs/${name6}.out"
  echo "queueing ${name6}"
		 
  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfnsub -s ${environment} --activation ${activation_layer} \
		 -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 --batch_size ${batch_size} -er 0.1
		 
  name7="${environment}_${seed}_teacher"
  outputfile="logs/${name7}.out"
  echo "queueing ${name7}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m teacher -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr  0.001  --nn_hidden_sizes 256 256 -d \
		 --seed ${seed} -sm 2 -te 0 --batch_size ${batch_size} -er 0.1
done


environment="gmm-hard"
activation_layer="leakyr"
total_step="30000"

for seed in 470 3825 4444 8888 9528
do
  name="${environment}_${seed}_${sampling}_${temperature}"
  outputfile="logs/${name}.out"
  echo "queueing ${name}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
		 -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 \
		 --seed ${seed} -sm 2 -te 0 --batch_size 16 -tr 10

  name2="${environment}_${seed}_${sampling}_${temperature}_usefilter"
  outputfile="logs/${name2}.out"
  echo "queueing ${name2}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
		 -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 \
		 --seed ${seed} -sm 3 -te 1.0 \
		 -uf --batch_size 16 -fu 2 -fl 1 -tr 10
  
  name3="${environment}_${seed}_gafn"
  outputfile="logs/${name3}.out"
  echo "queueing ${name3}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gafn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 \
		 --seed ${seed} -sm 2 -te 0 --batch_size 32 -er 0.1

  name4="${environment}_${seed}_pbgfn"
  outputfile="logs/${name4}.out"
  echo "queueing ${name4}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.005  --nn_hidden_sizes 256 256 \
		 --seed ${seed} -sm 2 -te 0 \
		 -pu 8 --batch_size 16 -er 0.1
  
  name5="${environment}_${seed}_vanillagfn"
  outputfile="logs/${name5}.out"
  echo "queueing ${name5}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 \
		 --seed ${seed} -sm 0 -te 0 --batch_size 16
  
  name6="${environment}_${seed}_gfnsub"
  outputfile="logs/${name6}.out"
  echo "queueing ${name6}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfnsub -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256\
		 --seed ${seed} -sm 2 -te 0 --batch_size 16
		 
  name7="${environment}_${seed}_teacher"
  outputfile="logs/${name7}.out"
  echo "queueing ${name7}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \\
		 -m teacher -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 \
		 --seed ${seed} -sm 2 -te 0 --batch_size 32 -er 0.1	
  
done

environment="pusher-simple"
learning_rate="0.00001"
activation_layer="leakyr"
total_step="40000"

for seed in 470 3825 4444 8888 9528
do
  name="${environment}_${seed}_${sampling}_${temperature}"
  outputfile="logs/${name}.out"
  echo "queueing ${name}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
		 -t ${total_step} -lr ${learning_rate}  --nn_hidden_sizes 128 128 \
		 --seed ${seed} -sm 2 -te 0 --batch_size 32 -tr 10

  name2="${environment}_${seed}_${sampling}_${temperature}_usefilter"
  outputfile="logs/${name2}.out"
  echo "queueing ${name2}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
		 -t ${total_step} -lr ${learning_rate}  --nn_hidden_sizes 128 128 \
		 --seed ${seed} -sm 3 -te 1.0 \
		 -uf --batch_size 32 -fl 0 -fu 0  -tr 10
  
  name3="${environment}_${seed}_gafn"
  outputfile="logs/${name3}.out"
  echo "queueing ${name3}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gafn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr ${learning_rate}  --nn_hidden_sizes 256 256 \
		 --seed ${seed} -sm 2 -te 0 --batch_size 32

  name4="${environment}_${seed}_pbgfn"
  outputfile="logs/${name4}.out"
  echo "queueing ${name4}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.0001  --nn_hidden_sizes 128 128 \
		 --seed ${seed} -sm 2 -te 0 \
		 -pu 8 --batch_size 16
  
  name5="${environment}_${seed}_vanillagfn"
  outputfile="logs/${name5}.out"
  echo "queueing ${name5}"
  
  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfn -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr ${learning_rate}  --nn_hidden_sizes 128 128 \
		 --seed ${seed} -sm 0 -te 0 --batch_size 32
		 
  name6="${environment}_${seed}_gfnsub"
  outputfile="logs/${name6}.out"
  echo "queueing ${name6}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m gfnsub -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr 0.000001  --nn_hidden_sizes 128 128 \
		 --seed ${seed} -sm 0 -te 0 --batch_size 32
		 
  name7="${environment}_${seed}_teacher"
  outputfile="logs/${name7}.out"
  echo "queueing ${name7}"

  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
		 -m teacher -s ${environment} --activation ${activation_layer} \
         -t ${total_step} -lr ${learning_rate}  --nn_hidden_sizes 256 256 \
		 --seed ${seed} -sm 2 -te 0 --batch_size 32
  
done