#!/bin/bash
cd code
if [ $? -ne 0 ]; then
  echo "Failed to change directory to code"
  exit 1
fi

TIMESTAMP=$(date '+%Y%m%d_%H%M%S')

activation_layer="leakyr"
environment="hypergrid-mild"
total_step="20000"

for temperature in 0 0.01
do
	for sampling in  0 2 3
	do
		for seed in 470 3825 4444 8888 9528
		do		
		  name1="${environment}_${seed}_ours"
		  outputfile="logs/${name1}.out"
		  echo "queueing ${name1}"

		  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
				 -m gfn -s ${environment} --activation ${activation_layer} \
				 -t ${total_step} -lr 0.005  --nn_hidden_sizes 256 256 -d -uf\
				 --seed ${seed} -sm ${sampling} -te ${temperature} --batch_size 16 -er 0 -fu 3 -fl 1 -tr 10
		   
		  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
				 -m gfn -s ${environment} --activation ${activation_layer} \
				 -t ${total_step} -lr 0.005  --nn_hidden_sizes 256 256 -d\
				 --seed ${seed} -sm ${sampling} -te ${temperature} --batch_size 16 -er 0 -tr 10

		 done
	done
done

environment="hypergrid-hard"
total_step="20000"

for temperature in 0 0.01
do
	for sampling in  0 2 3
	do
		for seed in 470 3825 4444 8888 9528
		do		
		  name2="${environment}_${seed}_ours"
		  outputfile="logs/${name2}.out"
		  echo "queueing ${name2}"
				 
		  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
				 -m gfn -s ${environment} --activation ${activation_layer} \
				 -t ${total_step} -lr 0.0001  --nn_hidden_sizes 256 256 -d -uf\
				 --seed ${seed} -sm ${sampling}  -te ${temperature} --batch_size 16 -er 0 -fu 3 -fl 1 -tr 10
				 
		  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
				 -m gfn -s ${environment} --activation ${activation_layer} \
				 -t ${total_step} -lr 0.0001  --nn_hidden_sizes 256 256 -d \
				 --seed ${seed} -sm ${sampling}  -te ${temperature} --batch_size 16 -er 0 -tr 10
				 
		  done
	done
done


environment="molecular-generation"
total_step="30000"

for temperature in 0 0.001
do
	for sampling in  0 2 3
	do
		for seed in 470 3825 4444 8888 9528
		do
		  name5="${environment}_${seed}_ours"
		  outputfile="logs/${name5}.out"
		  echo "queueing ${name5}"
				 
		  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
				 -m gfn -s ${environment} --activation ${activation_layer} \
				 -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 -d -uf\
				 --seed ${seed} -sm ${sampling} -te ${temperature} --batch_size 16 -er 0.1 -fu 1 -fl 2
				 
		  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
				 -m gfn -s ${environment} --activation ${activation_layer} \
				 -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 -d\
				 --seed ${seed} -sm ${sampling} -te ${temperature} --batch_size 16 -er 0.1
		done
	done
done


environment="gmm-hard"
total_step="30000"

for temperature in 0 1.0
do
	for sampling in  0 2 3
	do
		for seed in 470 3825 4444 8888 9528
		  do
		  name5="${environment}_${seed}_ours"
		  outputfile="logs/${name5}.out"
		  echo "queueing ${name5}"

		  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
				 -m gfn -s ${environment} --activation ${activation_layer} \
				 -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256 -uf\
				 --seed ${seed} -sm ${sampling} -te ${temperature} --batch_size 16 -er 0 -fu 2 -fl 1 -tr 10
				 
		  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
				 -m gfn -s ${environment} --activation ${activation_layer} \
				 -t ${total_step} -lr 0.001  --nn_hidden_sizes 256 256\
				 --seed ${seed} -sm ${sampling} -te ${temperature} --batch_size 16 -er 0 -tr 10

		  done
	done
done

environment="pusher-simple"
total_step="40000"

for temperature in 0 1.0
do
	for sampling in  0 2 3
	do
		for seed in 470 3825 4444 8888 9528
		  do
		  
		  name5="${environment}_${seed}_ours"
		  outputfile="logs/${name5}.out"
		  echo "queueing ${name5}"

		  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
				 -m gfn -s ${environment} --activation ${activation_layer} \
				 -t ${total_step} -lr 0.00001  --nn_hidden_sizes 128 128 -uf\
				 --seed ${seed} -sm ${sampling} -te ${temperature} --batch_size 32 -er 0 -fu 0 -fl 1 -tr 10	
				 
		  python train.py --train_freq 16 -iz 0.1 -nvs 0 -p \
				 -m gfn -s ${environment} --activation ${activation_layer} \
				 -t ${total_step} -lr 0.00001  --nn_hidden_sizes 128 128\
				 --seed ${seed} -sm ${sampling} -te ${temperature} --batch_size 32 -er 0 -tr 10	
				 
  		done
	done
done