# HedonicNeuron

This repository provides datasets and model checkpoints used for fine-tuning reranker models and probing large language models (LLMs) in our NeurIPS submission.

### 📚 Datasets

**Training Dataset**  
- Tevatron MSMARCO Passage Augmented  
  [HuggingFace Link](https://huggingface.co/datasets/Tevatron/msmarco-passage-aug)

**Evaluation Dataset**  
- TREC Deep Learning 2019  
  [Official Link](https://microsoft.github.io/msmarco/TREC-Deep-Learning-2019.html)

Fine-tuning follows the same procedure as outlined in the Tevatron MSMARCO implementation.

---

### 🧠 Finetuned Reranker Model Checkpoints

Below are the HuggingFace model IDs of the fine-tuned rerankers used in our experiments:

#### **Rank 8 Rerankers**
| Model | HuggingFace ID | Tokenizer |
|-------|----------------|-----------|
| Pythia | `AnonymousForReview2/finegrained_checkpoint_experiment_rankpythia_r8_mlp_only` | `EleutherAI/pythia-6.9b` |
| Mistral | `AnonymousForReview2/finegrained_checkpoint_experiment_rankmistral_r8_mlp_only` | `mistralai/Mistral-7B-v0.1` |
| LLaMA3 | `AnonymousForReview2/finegrained_checkpoint_experiment_llama3_r8_lora_mlp` | `meta-llama/Llama-3.1-8B` |

#### **CQTR LLMs (Covered Query Term Ratio)**
| Model | HuggingFace ID | Tokenizer |
|-------|----------------|-----------|
| Pythia | `AnonymousForReview2/watereddown_reranker_pythia_cqtr_mlp_only` | `EleutherAI/pythia-6.9b` |
| Mistral | `AnonymousForReview2/watereddown_reranker_mistral_cqtr_mlp_only` | `mistralai/Mistral-7B-v0.1` |
| LLaMA3 | `AnonymousForReview2/watereddown_reranker_llama3_cqtr_mlp_only` | `meta-llama/Llama-3.1-8B` |

#### **Mean(tf/l) LLMs**
| Model | HuggingFace ID | Tokenizer |
|-------|----------------|-----------|
| Pythia | `AnonymousForReview2/watereddown_reranker_pythia_tf_l_mlp_only` | `EleutherAI/pythia-6.9b` |
| Mistral | `AnonymousForReview2/watereddown_reranker_mistral_tf_l_mlp_only` | `mistralai/Mistral-7B-v0.1` |
| LLaMA3 | `AnonymousForReview2/watereddown_reranker_llama3_tf_l_mlp_only` | `meta-llama/Llama-3.1-8B` |

---

# Code Overview

## Scripts

1. `top_cover.py` — Main Code to generate coalitions
2. `partition_rankmistral.py` — Code to generate partitions
3. `clustering.py` — Baseline clustering  
4. `eval_local_logit.py` — Evaluate coalition synergy  
5. `bipartite.py` — Latent coalition tracking  
6. `sankey.py` — Sankey visualization helpers  


## Folders

- `partitions/`  
  Contains coalition `.pkl` files for 3 LLMs, layers 7–14, generated via 2 methods: OCA and PAS

- `sankey_plots/`  
  Mistral Layer 8 Sankey visualizations with 2 different thresholds.  
  Threshold determines the weight below which connections are zeroed.
  
- `finetuning/`  
  Code and links for finetuning the required models.

- `deepspeed/`  
  Contains deepspeed configuration detailing all the hyper-parameter requirements for the finetuning of the model.

### ⚠️ Note

Accessing models based on **LLaMA3** requires appropriate permissions from Meta. Please ensure you have the necessary license agreements in place before attempting to use these checkpoints.

