# Fine-tuning Rerankers and Lightweight Feature Prediction Models

This directory contains code for fine-tuning reranker models as well as LLMs trained to predict lightweight IR features such as **mean term frequency normalized by length (mean tf/l)** and **covered query term ratio (CQTR)**.
This directory contains all the necessary code to reproduce the fine-tuning results, with appropriate modifications such as setting up the Tevatron repository, updating login keys, and adjusting commands and codebases accordingly.
We have provided the ouputs of our finetuned models on the sampled dl19 dataset.

## Overview

- `lora_finetune_llm.sbatch`: Example SLURM script to launch a fine-tuning job using the provided code.
- `eval_watereddown_llm.sbatch`: Example SLURM script to evaluate a fine-tuned model.
- `dl19_sampled_subset.jsonl`: A sampled evaluation subset from the TREC DL19 dataset.

## Codebase Details

- Fine-tuning and evaluation of rerankers builds upon the [Tevatron repository](https://github.com/texttron/tevatron/tree/main/examples/rankllama).
- For rerankers follow exact procedure as described in the [Tevatron repository](https://github.com/texttron/tevatron/tree/main/examples/rankllama).
- For CQTR and mean(tf/l) prediction tasks, we adapted Tevatron's code to accommodate these supervised regression targets.

Create folders named as model_outputs and inference_files to save the models as well as the inference files.

## Scripts for Specialized Training

- To fine-tune for **covered query term ratio (CQTR)**, use:
  ```
  watereddown_reranker.py
  ```

- To fine-tune for **mean normalized term frequency**, use:
  ```
  watereddown_reranker_normalized_tf.py
  ```

## Post-evaluation

After evaluating your fine-tuned models (e.g., on MSE loss), run:
```
calculate_mse.py
```
Make sure to adjust file paths and model outputs as necessary.

## Note

Please update the Hugging Face login credentials wherever applicable before running the scripts.
