import pickle


base_llm_to_base_model_path = {
    
    "llama" : "finegrained_checkpoint_experiment_llama3_r8_lora_mlp_0/checkpoint-1/",
    "pythia" : "finegrained_checkpoint_experiment_rankpythia_r8_lora_mlp_0_checkpoint/checkpoint-1/",
    "mistral" : "finegrained_checkpoint_experiment_rankmistral_r8_lora_mlp_0_checkpoint/checkpoint-1/"
    
}

base_llm_to_ft_model_path = {
    
    "llama" : "finegrained_checkpoint_experiment_llama3_r8_lora_mlp/",
    "pythia" : "finegrained_checkpoint_experiment_rankpythia_r8_mlp_only/",
    "mistral" : "finegrained_checkpoint_experiment_rankmistral_r8_mlp_only/"
    
}


base_llm_to_tokenizer = {
    
    "llama" : "meta-llama/Llama-3.1-8B",
    "pythia" : "EleutherAI/pythia-6.9b",
    "mistral" : "mistralai/Mistral-7B-v0.1"
    
}

base_llm_to_gt_output = {
    
    "llama" : "./inference_files/run.finegrained_checkpoint_experiment_llama3_r8_lora_mlp_dl19_sampled_subset.psg.dl19.txt",
    "pythia" : "./inference_files/run.finegrained_checkpoint_experiment_rankpythia_r8_mlp_only_sampled_subset.psg.dl19.txt",
    "mistral" : "./inference_files/run.finegrained_checkpoint_experiment_rankmistral_r8_mlp_only_sampled_subset.psg.dl19.txt"
    
}





# Replace with your actual file path
# file_path = "partitions/covariate/llama_8_relevance.pkl"
parent_folder = "../partitions"
# parent_folder = "partitions"
base_models = ["llama", "mistral", "pythia"]
strategies = ["covariate", "large_covariate"]
layers = [7,8,9,10,11,12,13,14]

# # example file path
# file_path = "partitions/activation_correlation/llama_7_relevance.pkl"
coalition_map = {
    
}

for strategy in strategies :
    coalitions_strategy = {}
    
    for base_model in base_models :
        coalitions_base = {}
        for layer in layers:
            file_path = f"{parent_folder}/{strategy}/{base_model}_{layer}_relevance.pkl"
            # Load partition file
            with open(file_path, 'rb') as f:
                data = pickle.load(f)

            # Optional: Remove small coalitions (len ≤ 2)
            data = [lst for lst in data if len(lst) > 2]

            # Sort each coalition internally
            data = [sorted(lst) for lst in data]

            # Sort all coalitions in decreasing order of size
            data = sorted(data, key=len, reverse=True)
            coalitions_layer = {}
            # Print the coalitions
            for i, coalition in enumerate(data, 1):
                coalitions_layer[i] = coalition
            coalitions_base[layer] = coalitions_layer
        coalitions_strategy[base_model] = coalitions_base
    coalition_map[strategy] = coalitions_strategy
            
# print(coalition_map)            



