import sys
sys.path.append(".")

from image_uncertainty.cifar.cifar_training import train_model #, get_args
from image_uncertainty.cifar.cifar_evaluate import evaluate, load_model, get_eval_args


def main():
    args = get_eval_args()

    if args.weights:
        model_path = args.weights
    else:
        model_path = train_model(args)

    model = load_model(args.net, model_path, args.gpu)
    evaluate(model, args)


if __name__ == '__main__':
    main()

