cd ../../src
# Also add CoNLL-2003 - mixup

# Script for training all models on MRPC, COLA, SST2-10% and CoNLL-2003 for mixup
# train - MSD loss, no SN
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.self_ensembling\=True mixup.omega\=0.6 mixup.lam1\=0.05 mixup.lam2\=0.01 training.learning_rate\=5e-5 training.num_train_epochs\=11 training.per_device_train_batch_size\=64 +training.weight_decay\=0.01' task_configs=mrpc_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra/mrpc
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.self_ensembling\=True mixup.omega\=0.85 mixup.lam1\=0.2 mixup.lam2\=0.05 training.learning_rate\=3e-5 training.num_train_epochs\=12 training.per_device_train_batch_size\=32 +training.weight_decay\=0.1' task_configs=cola_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra/cola
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.self_ensembling\=True mixup.omega\=0.6 mixup.lam1\=0.006 mixup.lam2\=0.2 training.learning_rate\=2e-5 training.num_train_epochs\=11 training.per_device_train_batch_size\=32 +training.weight_decay\=0.1' task_configs=sst2_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra/sst2
# CoNLL
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py script=run_conll2003.py task_configs=conll2003_mixup.yaml args='do_ue_estimate\=False data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False mixup.self_ensembling\=True mixup.omega\=0.55 mixup.lam1\=0.05 mixup.lam2\=1.0 training.learning_rate\=7e-5 training.num_train_epochs\=6 training.per_device_train_batch_size\=8 +training.weight_decay\=0.01' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[0] output_dir='../workdir/run_train_models/mixup_electra/conll'

# Uncomment if want to train MSD with SN
# train - MSD loss, SN
#HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.self_ensembling\=True mixup.omega\=0.5 mixup.lam1\=0.2 mixup.lam2\=0.05 training.learning_rate\=7e-5 training.num_train_epochs\=3 training.per_device_train_batch_size\=16 +training.weight_decay\=0.01 +ue.use_spectralnorm\=True spectralnorm_layer\=last' task_configs=mrpc_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra_sn/mrpc
#HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.self_ensembling\=True mixup.omega\=0.85 mixup.lam1\=0.2 mixup.lam2\=0.03 training.learning_rate\=2e-5 training.num_train_epochs\=14 training.per_device_train_batch_size\=32 +training.weight_decay\=0.1 +ue.use_spectralnorm\=True spectralnorm_layer\=last' task_configs=cola_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra_sn/cola
#HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.self_ensembling\=True mixup.omega\=1.0 mixup.lam1\=0.002 mixup.lam2\=0.01 training.learning_rate\=7e-5 training.num_train_epochs\=3 training.per_device_train_batch_size\=16 +training.weight_decay\=0.01 +ue.use_spectralnorm\=True spectralnorm_layer\=last' task_configs=sst2_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra_sn/sst2
# CoNLL
#HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py script=run_conll2003.py task_configs=conll2003_mixup.yaml args='do_ue_estimate\=False data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False mixup.self_ensembling\=True mixup.omega\=0.5 mixup.lam1\=0.001 mixup.lam2\=1.0 training.learning_rate\=5e-5 training.num_train_epochs\=13 training.per_device_train_batch_size\=16 +training.weight_decay\=0.01 ue.use_spectralnorm\=True spectralnorm_layer\=last' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[0] output_dir='../workdir/run_train_models/mixup_electra_sn/conll'


# MC maha
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_electra/mrpc/msd/all'
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra/mrpc/msd/last'

HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_electra/cola/msd/all'
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra/cola/msd/last'

HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_electra/sst2/msd/all'
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra/sst2/msd/last'

HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_electra/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=last data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False' cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_electra/conll/mixup/last'
HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_electra/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False' cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_electra/conll/mixup/all'



# Same with SN
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_sn/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.use_spectralnorm\=True spectralnorm_layer\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra_sn/mrpc/msd/all'
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_sn/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last ue.use_spectralnorm\=True spectralnorm_layer\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra_sn/mrpc/msd/last'

#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_sn/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.use_spectralnorm\=True spectralnorm_layer\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra_sn/cola/msd/all'
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_sn/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last ue.use_spectralnorm\=True spectralnorm_layer\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra_sn/cola/msd/last'

#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_sn/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.use_spectralnorm\=True spectralnorm_layer\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra_sn/sst2/msd/all'
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_sn/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last ue.use_spectralnorm\=True spectralnorm_layer\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra_sn/sst2/msd/last'

#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_electra_sn/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=last data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False ue.use_spectralnorm\=True spectralnorm_layer\=last' cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_electra_sn/conll/mixup/last'
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_ner_for_model_series.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_electra_sn/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False ue.use_spectralnorm\=True spectralnorm_layer\=last' cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_electra_sn/conll/mixup/all'


# 20ng
# TODO: switch script in run_glue_for_model_series
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py script=run_newsgroup.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/20ng_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/20ng/models/20ng_mixup/ script=run_newsgroup.py args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_electra/20ng/mixup/all'
#HYDRA_CONFIG_PATH=../configs/run_glue_for_model_series.yaml python ./run_glue_for_model_series.py script=run_newsgroup.py cuda_devices=[0] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/20ng_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra/20ng/models/20ng_mixup/ script=run_newsgroup.py args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra/20ng/mixup/last'

# Finally, calc metrics
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py table_metrics=['table_f1_micro','table_f1_macro'] runs_dir='../workdir/run_glue_for_model_series/mixup_electra/mrpc/msd/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/mrpc/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/mrpc/msd/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/mrpc/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/cola/msd/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/cola/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/cola/msd/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/cola/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/sst2/msd/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/sst2/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra/sst2/msd/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/sst2/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_electra/conll/mixup/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/conll/mixup/last'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_electra/conll/mixup/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra/conll/mixup/all'


# Metrics for sn case
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py table_metrics=['table_f1_micro','table_f1_macro'] runs_dir='../workdir/run_glue_for_model_series/mixup_electra_sn/mrpc/msd/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_sn/mrpc/msd/all'
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_sn_test/mrpc/msd/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_sn/mrpc/msd/last'

#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_sn/cola/msd/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_sn/cola/msd/all'
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_sn/cola/msd/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_sn/cola/msd/last'

#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_sn/sst2/msd/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_sn/sst2/msd/all'
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_sn/sst2/msd/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_sn/sst2/msd/last'

#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_electra_sn/conll/mixup/last/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_sn/conll/mixup/last'
#HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_electra_sn/conll/mixup/all/results' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_sn/conll/mixup/all'
