cd ../../src

# ELECTRA
# Script for training all models on MRPC, COLA, SST2-10% and CoNLL-2003 for mixup
# train - MSD loss, no SN
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.lam1\=0.1 mixup.lam2\=0.006 training.learning_rate\=3e-05 mixup.mixup\=True training.num_train_epochs\=11 mixup.omega\=0.5 training.per_device_train_batch_size\=8 mixup.self_ensembling\=True +training.weight_decay\=0.01' task_configs=mrpc_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/mrpc
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.lam1\=0.1 mixup.lam2\=0.006 training.learning_rate\=3e-05 mixup.mixup\=True training.num_train_epochs\=7 mixup.omega\=0.55 training.per_device_train_batch_size\=64 mixup.self_ensembling\=True +training.weight_decay\=0.01' task_configs=cola_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/cola
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.lam1\=0.1 mixup.lam2\=0.006 training.learning_rate\=3e-05 mixup.mixup\=True training.num_train_epochs\=7 mixup.omega\=0.55 training.per_device_train_batch_size\=64 mixup.self_ensembling\=True +training.weight_decay\=0.01' task_configs=sst2_mixup.yaml output_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/sst2
# CoNLL
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py script=run_conll2003.py task_configs=conll2003_mixup.yaml args='do_ue_estimate\=False data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False mixup.lam1\=1.0 mixup.lam2\=0.005 training.learning_rate\=5e-05 mixup.mixup\=True training.num_train_epochs\=9 mixup.omega\=0.95 training.per_device_train_batch_size\=8 mixup.self_ensembling\=True +training.weight_decay\=0' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[0,1,2,3,4,5] output_dir='../workdir/run_train_models/mixup_electra_fix_repro_fix/conll'


# One run broken for mrpc
# MC maha
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/mrpc/msd/all'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/mrpc/msd/last'

HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/cola/msd/all'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/cola/msd/last'

HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/sst2/msd/all'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_electra_fix_repro_fix/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/sst2/msd/last'

HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py script=run_conll2003.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_electra_fix_repro_fix/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=last data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False' cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_electra_fix_repro_fix/conll/mixup/last'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py script=run_conll2003.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_electra_fix_repro_fix/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False' cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_electra_fix_repro_fix/conll/mixup/all'



# Finally, calc metrics
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/mrpc/msd/all' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/mrpc/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/mrpc/msd/last' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/mrpc/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/cola/msd/all' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/cola/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/cola/msd/last' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/cola/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/sst2/msd/all' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/sst2/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_electra_fix_repro_fix/sst2/msd/last' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/sst2/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_electra_fix_repro_fix/conll/mixup/last' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/conll/mixup/last'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_electra_fix_repro_fix/conll/mixup/all' output_dir='../workdir/run_calc_ues_metrics/mixup_electra_fix_repro_fix/conll/mixup/all'














# DEBERTA

# train - MSD loss, no SN, Deberta
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.lam1\=0.01 mixup.lam2\=0.02 training.learning_rate\=9e-06 mixup.mixup\=True training.num_train_epochs\=12 mixup.omega\=0.5 training.per_device_train_batch_size\=8 mixup.self_ensembling\=True +training.weight_decay\=0.1 model.model_name_or_path\=microsoft/deberta-base' task_configs=mrpc_mixup.yaml output_dir=../workdir/run_train_models/mixup_deberta_fix_repro_fix/mrpc
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.lam1\=0.05 mixup.lam2\=0.003 training.learning_rate\=3e-05 mixup.mixup\=True training.num_train_epochs\=12 mixup.omega\=0.65 training.per_device_train_batch_size\=32 mixup.self_ensembling\=True +training.weight_decay\=0 model.model_name_or_path\=microsoft/deberta-base' task_configs=cola_mixup.yaml output_dir=../workdir/run_train_models/mixup_deberta_fix_repro_fix/cola
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.lam1\=0.01 mixup.lam2\=0.003 training.learning_rate\=1e-05 mixup.mixup\=True training.num_train_epochs\=11 mixup.omega\=0.95 training.per_device_train_batch_size\=4 mixup.self_ensembling\=True +training.weight_decay\=0.01 model.model_name_or_path\=microsoft/deberta-base' task_configs=sst2_mixup.yaml output_dir=../workdir/run_train_models/mixup_deberta_fix_repro_fix/sst2
# CoNLL
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py script=run_conll2003.py task_configs=conll2003_mixup.yaml args='do_ue_estimate\=False data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False model.model_name_or_path\=microsoft/deberta-base mixup.lam1\=0.1 mixup.lam2\=0.005 training.learning_rate\=3e-05 mixup.mixup\=True training.num_train_epochs\=15 mixup.omega\=0.95 training.per_device_train_batch_size\=4 mixup.self_ensembling\=True +training.weight_decay\=0.1' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[0,1,2,3,4,5] output_dir='../workdir/run_train_models/mixup_deberta_fix_repro_fix/conll'


# MC maha
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_deberta_fix_repro_fix/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_deberta_fix_repro_fix/mrpc/msd/all'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_deberta_fix_repro_fix/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_deberta_fix_repro_fix/mrpc/msd/last'

HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_deberta_fix_repro_fix/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_deberta_fix_repro_fix/cola/msd/all'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_deberta_fix_repro_fix/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_deberta_fix_repro_fix/cola/msd/last'

HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_deberta_fix_repro_fix/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_deberta_fix_repro_fix/sst2/msd/all'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_deberta_fix_repro_fix/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_deberta_fix_repro_fix/sst2/msd/last'

HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py script=run_conll2003.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_deberta_fix_repro_fix/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=last data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False' cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_deberta_fix_repro_fix/conll/mixup/last'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py script=run_conll2003.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_deberta_fix_repro_fix/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False' cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_deberta_fix_repro_fix/conll/mixup/all'



# Finally, calc metrics
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_deberta_fix_repro_fix/mrpc/msd/all' output_dir='../workdir/run_calc_ues_metrics/mixup_deberta_fix_repro_fix/mrpc/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_deberta_fix_repro_fix/mrpc/msd/last' output_dir='../workdir/run_calc_ues_metrics/mixup_deberta_fix_repro_fix/mrpc/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_deberta_fix_repro_fix/cola/msd/all' output_dir='../workdir/run_calc_ues_metrics/mixup_deberta_fix_repro_fix/cola/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_deberta_fix_repro_fix/cola/msd/last' output_dir='../workdir/run_calc_ues_metrics/mixup_deberta_fix_repro_fix/cola/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_deberta_fix_repro_fix/sst2/msd/all' output_dir='../workdir/run_calc_ues_metrics/mixup_deberta_fix_repro_fix/sst2/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_deberta_fix_repro_fix/sst2/msd/last' output_dir='../workdir/run_calc_ues_metrics/mixup_deberta_fix_repro_fix/sst2/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_deberta_fix_repro_fix/conll/mixup/last' output_dir='../workdir/run_calc_ues_metrics/mixup_deberta_fix_repro_fix/conll/mixup/last'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_deberta_fix_repro_fix/conll/mixup/all' output_dir='../workdir/run_calc_ues_metrics/mixup_deberta_fix_repro_fix/conll/mixup/all'








# DISTILBERT

# train - MSD loss, no SN, DistilBERT
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.lam1\=1.0 mixup.lam2\=0.001 training.learning_rate\=7e-05 mixup.mixup\=True training.num_train_epochs\=10 mixup.omega\=0.75 training.per_device_train_batch_size\=16 mixup.self_ensembling\=True +training.weight_decay\=0.1 model.model_name_or_path\=distilbert-base-cased' task_configs=mrpc_mixup.yaml output_dir=../workdir/run_train_models/mixup_distilbert_fix_repro_fix/mrpc
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.lam1\=0.02 mixup.lam2\=0.005 training.learning_rate\=9e-06 mixup.mixup\=True training.num_train_epochs\=13 mixup.omega\=0.5 training.per_device_train_batch_size\=4 mixup.self_ensembling\=True +training.weight_decay\=0.01 model.model_name_or_path\=distilbert-base-cased' task_configs=cola_mixup.yaml output_dir=../workdir/run_train_models/mixup_distilbert_fix_repro_fix/cola
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] args='ue\=mc do_ue_estimate\=False ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.dropout_subs\=last ue.use_cache\=False mixup.lam1\=0.1 mixup.lam2\=0.006 training.learning_rate\=3e-05 mixup.mixup\=True training.num_train_epochs\=7 mixup.omega\=0.55 training.per_device_train_batch_size\=64 mixup.self_ensembling\=True +training.weight_decay\=0.01 model.model_name_or_path\=distilbert-base-cased' task_configs=sst2_mixup.yaml output_dir=../workdir/run_train_models/mixup_distilbert_fix_repro_fix/sst2
# CoNLL
HYDRA_CONFIG_PATH=../configs/run_train_models.yaml python ./run_train_models.py script=run_conll2003.py task_configs=conll2003_mixup.yaml args='do_ue_estimate\=False data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False mixup.lam1\=0.1 mixup.lam2\=0.2 training.learning_rate\=5e-05 mixup.mixup\=True training.num_train_epochs\=13 mixup.omega\=0.9 training.per_device_train_batch_size\=4 mixup.self_ensembling\=True +training.weight_decay\=0.1 model.model_name_or_path\=distilbert-base-cased' seeds=[23419,705525,4837,10671619,1084218,43] cuda_devices=[0,1,2,3,4,5] output_dir='../workdir/run_train_models/mixup_distilbert_fix_repro_fix/conll'





# MC maha
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_distilbert_fix_repro_fix/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_distilbert_fix_repro_fix/mrpc/msd/all'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/mrpc_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_distilbert_fix_repro_fix/mrpc/models/mrpc_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_distilbert_fix_repro_fix/mrpc/msd/last'

HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_distilbert_fix_repro_fix/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_distilbert_fix_repro_fix/cola/msd/all'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/cola_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_distilbert_fix_repro_fix/cola/models/cola_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_distilbert_fix_repro_fix/cola/msd/last'

HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_distilbert_fix_repro_fix/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False' output_dir='../workdir/run_glue_for_model_series/mixup_distilbert_fix_repro_fix/sst2/msd/all'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] config_path=../configs/sst2_mixup.yaml model_series_dir=../workdir/run_train_models/mixup_distilbert_fix_repro_fix/sst2/models/sst2_mixup/ args='ue\=msd do_ue_estimate\=True ue.use_selective\=False ue.calibrate\=True data.validation_subsample\=0.0 training\=electra_base ue.use_cache\=False ue.dropout_subs\=last' output_dir='../workdir/run_glue_for_model_series/mixup_distilbert_fix_repro_fix/sst2/msd/last'

HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py script=run_conll2003.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_distilbert_fix_repro_fix/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=last data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False' cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_distilbert_fix_repro_fix/conll/mixup/last'
HYDRA_CONFIG_PATH=../configs/run_tasks_for_model_series.yaml python ./run_tasks_for_model_series.py script=run_conll2003.py config_path=../configs/conll2003_mixup.yaml model_series_dir='../workdir/run_train_models/mixup_distilbert_fix_repro_fix/conll/models/conll2003_mixup/' args='ue\=msd ue.calibrate\=True ue.use_cache\=False do_ue_estimate\=True ue.ue_type\=msd ue.dropout_subs\=all data.subsample_perc_val\=0.1 data.subsample_perc\=0.1 ue.use_selective\=False' cuda_devices=[0,1,2,3,4,5] seeds=[23419,705525,4837,10671619,1084218,43] output_dir='../workdir/run_ner_for_model_series/mixup_distilbert_fix_repro_fix/conll/mixup/all'



# Finally, calc metrics
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_distilbert_fix_repro_fix/mrpc/msd/all' output_dir='../workdir/run_calc_ues_metrics/mixup_distilbert_fix_repro_fix/mrpc/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_distilbert_fix_repro_fix/mrpc/msd/last' output_dir='../workdir/run_calc_ues_metrics/mixup_distilbert_fix_repro_fix/mrpc/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_distilbert_fix_repro_fix/cola/msd/all' output_dir='../workdir/run_calc_ues_metrics/mixup_distilbert_fix_repro_fix/cola/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_distilbert_fix_repro_fix/cola/msd/last' output_dir='../workdir/run_calc_ues_metrics/mixup_distilbert_fix_repro_fix/cola/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_distilbert_fix_repro_fix/sst2/msd/all' output_dir='../workdir/run_calc_ues_metrics/mixup_distilbert_fix_repro_fix/sst2/msd/all'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics.py runs_dir='../workdir/run_glue_for_model_series/mixup_distilbert_fix_repro_fix/sst2/msd/last' output_dir='../workdir/run_calc_ues_metrics/mixup_distilbert_fix_repro_fix/sst2/msd/last'

HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_distilbert_fix_repro_fix/conll/mixup/last' output_dir='../workdir/run_calc_ues_metrics/mixup_distilbert_fix_repro_fix/conll/mixup/last'
HYDRA_CONFIG_PATH=../configs/run_calc_ues_metrics.yaml python ./run_calc_ues_metrics_ner.py runs_dir='../workdir/run_ner_for_model_series/mixup_distilbert_fix_repro_fix/conll/mixup/all' output_dir='../workdir/run_calc_ues_metrics/mixup_distilbert_fix_repro_fix/conll/mixup/all'
