# POST: a framework for Privacy Of Soft-prompt Transfer

*Keywords:* prompt transfer, soft prompt, privacy, distillation, confidentiality

*TL;DR:* We propose a method on how to transfer soft prompts tuned on a distilled small model to a larger model using public data.

*Abstract:*
Prompting has emerged as a dominant learning paradigm for adapting large language models (LLMs). While discrete (textual) prompts prepend tokens to the input for optimized outputs, soft (parameter) prompts are tuned in the embedding space via backpropagation, requiring less engineering effort. However, unlike semantically meaningful discrete prompts, soft prompts are tightly coupled to the LLM they were tuned on, hindering their generalization to other LLMs. This limitation is particularly problematic when efficiency and privacy are concerns, since (1) it requires tuning new prompts for each LLM which, due to the backpropagation, becomes increasingly computationally expensive as LLMs grow in size, and (2) when the LLM is centrally hosted, it requires sharing private data for soft prompt tuning with the LLM provider. To address these concerns, we propose a framework for Privacy Of Soft-prompt Transfer (POST), a novel method that enables private soft prompt tuning on a small language model and then transfers the prompt to the large LLM. Using knowledge distillation, we first derive the small language model directly from the LLM to facilitate prompt transferability. Then, we tune the soft prompt locally, if required with privacy guarantees, e.g.,  according to differential privacy. Finally, we use a small set of public data to transfer the prompt from the small model to the large LLM without additional privacy leakage. Our experimental results demonstrate that our method effectively transfers soft prompts, protecting local data privacy and reducing the computational complexity over soft prompt tuning on the large model.
## requirements

`pip install -r requirements.txt`

## usage
1. prepare dataset    
use `disll/process_data.py` and `disll/token_counts.py` to generate dataset used for knowledge distillation  
use `disll/extract_distill_model.py` to get the initialization of source model   
use `distill/train.py` to get the dsitlled source model 
2. train soft prompt on source model  
run `scripts/train_prompt.py` to train soft prompt without DP  
run `scripts/train_DP_prompt.py` to train soft prompt with DP  
3. prompt transfer
run `scripts/prompt_transfer.py` to transfer prompt need to specify the public dataset



