# SpaRTeN: 
## Spatially Resolved Temporal Networks.

*in review*

Here we present the implementation for Spatially Resolved Temporal Networks as a new method to perform online unsupervised 
time series representation learning in the context of high-frequency time series. SpaRTeN achieves SOTA on an online
forecasting task for MIMIC, a waveform database derived from ICU monitors. Simultaneously, SpaRTeN can produce simple
representations for complex high-frequency time series, providing an interpretable approach towards analyzing complex stochastic processes. SpaRTeN more generally refers to a framework, rather than specific network approach, and as a result, we anticipate 
that including larger models inside the framework will only serve to further improve the efficacy of the network
for generalized time series analysis. 

## Abstract

We propose a composite deep learning model for generating a spatial representation of state-dependent changes in high frequency time series, in which we simultaneously train two distinct blocks: a recurrent neural network ensemble R that captures states in high frequency time series, and a spatial block S that spatially projects state changes from the predictions generated by R. The training procedure for R is to optimize the block that best fits the current state, which is predicted by the spatial block S. When S and R are deep neural networks, the entire system can be trained via backpropagation. We thenvalidate the potential of using this framework to demonstrate real-time state changes through qualitative and quantitative mapping of projected state values and demonstrate the potential for this network to qualitatively measure treatment effect on waveform data using real world data and examples.

## Spatially Resolved Temporal Networks
![Figure 1](./static/Figure1.png)


## Installation

This model currently requires PyTorch. This is best done inside a virtual environment. We use Python 3.9 with PyTorch (1.10). 

```
conda create -n deephfts 
source deephfts/bin/activate 
pip install -r requirements.txt
```

## Training New Networks

To train a new model with a high-frequency time series dataset, a path to an input csv file must be provided with the columns.

| series | time_idx | value |
|--------|----------|-------|
|   0    |    1     | 0.0113|
|   0    |    2     | 0.0219|
|   0    |    3     | 0.0342|
|   0    |   ...    |  ...  |

where series represents an independent time series, time_idx represents the time point in the time series,
and value represents the value at a given time-point in the time series. 

You can set this .csv file equal to --path in the arguments. 

```
usage: train.py [-h] --path PATH --run_name RUN_NAME [--breakpoint BREAKPOINT] [--checkpoint_path CHECKPOINT_PATH]
                [--checkpoint_interval CHECKPOINT_INTERVAL] [--tensorboard] [--width WIDTH] [--height HEIGHT] [--mode MODE]
                [--window_size WINDOW_SIZE] [--forecast_size FORECAST_SIZE] [--zsl_path ZSL_PATH] [--cfi_path CFI_PATH]

Configuration arguments for training model.

optional arguments:
  -h, --help            show this help message and exit
  --path PATH           Path to a csv file with columns series, time_idx, value.
  --run_name RUN_NAME   Name of the run.
  --breakpoint BREAKPOINT
                        Break point for training loop.
  --checkpoint_path CHECKPOINT_PATH
                        Path for checkpointing model.
  --checkpoint_interval CHECKPOINT_INTERVAL
                        Number of time steps to checkpoint after.
  --tensorboard         Use the tensorboard logger.
  --width WIDTH         Width of R-Block.
  --height HEIGHT       Height of R-Block.
  --mode MODE           Either online or offline.
  --window_size WINDOW_SIZE
                        Size of the window.
  --forecast_size FORECAST_SIZE
                        Size of the window.
  --zsl_path ZSL_PATH   Path to an output file for zero-shot learning.
  --cfi_path CFI_PATH   Path to an output file for counterfactual inference.
```

## Key Results

We benchmark an online forecasting task for 60,000 MIMIC EKG lead II waveforms using 3 other state of the art models
for online forecasting like Long-Short Term Memory Networks (LSTMs), N-Beats, Temporal Fusion Transformers (TFT).

We report sMAPE, which is a common benchmark for time series forecasting tasks used in the M4, M5 Competitions.
<p align="center">
  <img src="./static/sMAPE.png" width="250" ></a>
</p>

| dataset |   LSTM  | N-Beats |    TFT   | SpaRTeN |
|---------|---------|---------|----------|---------|
| MIMIC   |   2.40  |   1.53  |   1.67   | **1.42**|

## Citation

```
@misc{Anonymous,
  author = {Anonymous},
  title = {Spatially Resolved Temporal Networks},
  year = {2022},
  publisher = {GitHub},
  journal = {GitHub repository},
  howpublished = {\url{https://github.com/deepHFTS}}
}
```
