import argparse

from deephfts.training_loop import training_loop

def main(**config_kwargs):
    training_loop(**config_kwargs)



if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Configuration arguments for training model.')

    parser.add_argument("--path", type=str, required=True,
                        help="Path to a csv file with columns series, time_idx, value.")
    
    parser.add_argument("--run_name", type=str, required=True,
                        help="Name of the run.")
    
    parser.add_argument("--breakpoint", type=int, required=False,
                        help="Break point for training loop.")
    
    parser.add_argument("--checkpoint_path", type=str, required=False,
                        help="Path for checkpointing model.")
    
    parser.add_argument("--checkpoint_interval", type=int, required=False, default=100,
                        help="Number of time steps to checkpoint after.")
    
    parser.add_argument("--tensorboard", action='store_true',
                        help="Use the tensorboard logger.")
    
    parser.add_argument("--width", type=int, required=False, default=3,
                        help="Width of R-Block.")
    
    parser.add_argument("--height", type=int, required=False, default=3,
                        help="Height of R-Block.")
    
    parser.add_argument("--mode", type=str, required=False, default="online",
                        help="Either online or offline.")
    
    parser.add_argument("--window_size", type=int, required=False, default=80,
                        help="Size of the window.")
    
    parser.add_argument("--forecast_size", type=int, required=False, default=20,
                        help="Size of the window.")
    
    parser.add_argument("--zsl_path", type=str, required=False,
                        help="Path to an output file for zero-shot learning.")

    parser.add_argument("--cfi_path", type=str, required=False,
                        help="Path to an output file for counterfactual inference.")

    config_kwargs = parser.parse_args()
    main(**vars(config_kwargs))