# Code for Implementing FedGLAD

## Base Code

Our code is based on the two open-sourced federated learning platforms: [FedML](https://github.com/FedML-AI/FedML) and [FedNLP](https://github.com/FedML-AI/FedNLP). Researchers should first follow the instructions in [FedNLP](https://github.com/FedML-AI/FedNLP) to install them at the same time.



## Updates about FedGLAD

Based on the source code in FedML and FedNLP, we made the modifications to make the FedGLAD applicable with the original baselines. **For reader's convenience, the structure of this supplemental material is consistent with that of the directory if you follow the instructions in [FedNLP](https://github.com/FedML-AI/FedNLP) to install the platforms.** Our modifications are mainly in the directory  ``FedNLP/FedML/fedml_api/distributed/``, since the sub-folders (``fedavg``, ``fedprox`` and ``fedopt``) in this directory contain the core code of the federated optimization baselines.

Since the entire FedNLP and FedML directories are too big (especially the raw data and the processed data for text classification tasks) and complicated to upload, and we only modified some of the core files, here we only upload the core code for applying FedGLAD with all baselines on CIFAR-10 and MNIST datasets for quick experiments. Experiments on NLP tasks can be conducted following the instructions in [FedNLP](https://github.com/FedML-AI/FedNLP).



## Usage

First of all, **follow the instructions in [FedNLP](https://github.com/FedML-AI/FedNLP) to install the two platforms.**

Then use the files in our directories ``FedNLP/FedML/fedml_api``, ``FedNLP/FedML/fedml_experiments`` and ``FedNLP/transformers`` to **replace** those files with the **same names** and under the **same named directories**. For example, replace the original directory ``FedNLP/FedML/fedml_experiments/distributed/fedavg`` installed from [FedNLP](https://github.com/FedML-AI/FedNLP)  with the directory ``FedNLP/FedML/fedml_experiments/distributed/fedavg`` provided in this supplemental material.

To run experiments, move to the directory  ``FedNLP/FedML/fedml_experiments/distributed/`` provided in this supplemental material, we provide a detailed **README.md** to help to conduct the experiments with FedAvg, FedProx, FedAvgM, FedAdam and FedGLAD.





