#!/bin/bash
### need to change to your path ###
calvin_dataset_path="calvin/dataset/task_ABC_D"
save_checkpoint_path="checkpoints/Q-model"
finetune_from_pretrained_ckpt="checkpoints/seer_large/Seer-Large-PT-ep5-FT-ep12.pth"
vit_checkpoint_path="checkpoints/vit_mae/mae_pretrain_vit_base.pth" # downloaded from https://drive.google.com/file/d/1bSsvRI4mDM3Gg51C6xO0l9CbojYw3OEt/view?usp=sharing
node=1
node_num=1
export CUDA_VISIBLE_DEVICES='3,4,5,6,7'
torchrun --nnodes=${node} --nproc_per_node=${node_num} --master_port=10211 q_train.py \
    --traj_cons \
    --rgb_pad 10 \
    --gripper_pad 4 \
    --gradient_accumulation_steps 1 \
    --bf16_module "vision_encoder" \
    --vit_checkpoint_path ${vit_checkpoint_path} \
    --calvin_dataset ${calvin_dataset_path} \
    --workers 8 \
    --lr_scheduler cosine \
    --save_every_iter 100000 \
    --num_epochs 5 \
    --seed 42 \
    --batch_size 8 \
    --precision fp32 \
    --learning_rate 1e-5 \
    --warmup_epochs 1 \
    --finetune_type "calvin" \
    --wandb_project seer_q_model \
    --weight_decay 1e-4 \
    --num_resampler_query 16 \
    --num_obs_token_per_image 16 \
    --run_name finetune_Seer-Large_to_q-model \
    --save_checkpoint_path ${save_checkpoint_path} \
    --transformer_layers 24 \
    --hidden_dim 1024 \
    --transformer_heads 16 \
    --phase "finetune" \
    --value_pred_steps 1 \
    --sequence_length 10 \
    --future_steps 3 \
    --window_size 13 \
    --obs_pred \
    --loss_image \
    --loss_value \
    --loss_action \
    --save_checkpoint \
    --report_to_wandb \
    --finetune_from_pretrained_ckpt ${finetune_from_pretrained_ckpt} \


