# Creating a Python Environment

To create a Python environment:

1. **Install `virtualenv`**:

    ```sh
    pip install virtualenv
    ```

2. **Create a Virtual Environment**:

    ```sh
    virtualenv venv
    ```

3. **Activate the Virtual Environment**:
    - Windows:

      ```sh
      .\venv\Scripts\activate
      ```

    - macOS/Linux:

      ```sh
      source venv/bin/activate
      ```

4. **Install Dependencies**:

    ```sh
    pip install -r requirements.txt
    ```

5. **Deactivate the Virtual Environment**:

    ```sh
    deactivate
    ```

## Running Benchmarks

The code includes several benchmark functions to evaluate fairness metrics:

1. **Fixed Calculate**: Evaluates fairness with fixed parameters
2. **Fit Calculate**: Evaluates fairness with fitted parameters
3. **WDF Calculate**: Evaluates Wasserstein Distributional Fairness
4. **Delta Calculate**: Evaluates fairness across different delta values

To run the benchmarks:

```sh
python -m run_benchmarks --seed <random_seed>
```

For example:

```sh
python -m run_benchmarks --seed 0
```

The benchmarks will:

- Run on multiple datasets (COMPAS, German Credit, Bank Marketing, etc.)
- Test different classifiers (Logistic Regression, Linear SVM, etc.)
- Calculate fairness metrics and save results to CSV files in the `results` directory

Results will be saved as:

- `fairness_metrics_{dataset}_{classifier}_fixed.csv`
- `fairness_metrics_{dataset}_{classifier}_fit.csv`
- `fairness_metrics_{dataset}_{classifier}_wdf.csv`
- `fairness_metrics_{dataset}_{classifier}_delta.csv`