import argparse
from src.utils import set_seed


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--model", type=str, default="EleutherAI/gpt-j-6b")
    parser.add_argument("--low_resource_mode", action="store_true")
    parser.add_argument("--cuda", action="store_true")
    parser.add_argument("--seed", type=int, default=0)

    parser.add_argument("--dataset", type=str, default="glue-cola")
    parser.add_argument("--split", type=str, default="validation")
    parser.add_argument("--sampling", type=str, default="uniform")
    parser.add_argument("--num_samples", type=int, default=8)
    parser.add_argument("--subset", type=int, default=None)
    parser.add_argument("--prompt_type", type=str, default="none")
    parser.add_argument("--metrics", type=str, default="accuracy", nargs="+")

    parser.add_argument("--output_dir", type=str)

    args = parser.parse_args()
    set_seed(args.seed)

    print(args.__dict__)
    return args
