
# Create a new tmux session
# session_name="irobot_create3_nav_fallback_$(date +%s)"
session_name="nav_fallback"
tmux new-session -d -s $session_name

# Split the window into three panes
tmux selectp -t 0    # select the first (0) pane
tmux splitw -v -p 50 # split it into two halves
tmux selectp -t 1    # go back to the first pane
tmux splitw -h -p 50 # split it into two halves
tmux selectp -t 0   # go back to the first pane
tmux splitw -h -p 50 # split it into two halves
tmux selectp -t 1    # go back to the first pane
tmux splitw -v -p 50 # split it into two halves
tmux selectp -t 0   # go to second pane 
tmux splitw -v -p 50 # split it into two halves
tmux selectp -t 4
tmux splitw -v -p 50

# Launch sensors and robot description
tmux select-pane -t 1
tmux send-keys "source ~/create_ws/install/setup.bash" Enter
tmux send-keys "ros2 service call /reset_pose irobot_create_msgs/ResetPose" Enter
tmux send-keys "ros2 param set motion_control reflexes_enabled False" Enter
tmux send-keys "ros2 param set motion_control reflexes.REFLEX_BUMP False" Enter
tmux send-keys "ros2 param set motion_control reflexes.REFLEX_CLIFF False" Enter
tmux send-keys "ros2 param set motion_control reflexes.REFLEX_DOCK_AVOID False" Enter
tmux send-keys "ros2 param set motion_control reflexes.REFLEX_GYRO_CAL False" Enter
tmux send-keys "ros2 param set motion_control reflexes.REFLEX_PANIC False" Enter
tmux send-keys "ros2 param set motion_control reflexes.REFLEX_PROXIMITY_SLOWDOWN False" Enter
tmux send-keys "ros2 param set motion_control reflexes.REFLEX_STUCK False" Enter
tmux send-keys "ros2 param set motion_control reflexes.REFLEX_VIRTUAL_WALL False" Enter
tmux send-keys "ros2 param set motion_control reflexes.REFLEX_WHEEL_DROP False" Enter
tmux send-keys "ros2 launch deployment robot_launch.py" Enter

# Run the navigation stack
tmux select-pane -t 2
tmux send-keys "source ~/create_ws/install/setup.bash" Enter
tmux send-keys "ros2 launch deployment bringup_keepout_launch.py params_file:=/home/create/create_ws/src/deployment/config/nav2_params_keepout.yaml map:=/home/create/create_ws/src/deployment/maps/<MAP>.yaml" Enter

# robot action server
tmux select-pane -t 6
tmux send-keys "source ~/create_ws/install/setup.bash" Enter
tmux send-keys "python ~/create_ws/src/deployment/deployment/nav_robot_action_server.py " Enter

# Launch foxglove
tmux select-pane -t 0
tmux send-keys "source ~/create_ws/install/setup.bash" Enter
tmux send-keys "ros2 launch foxglove_bridge foxglove_bridge_launch.xml" Enter

sleep 10 # gives it enough time to load everything properly 
# Filter Mask
tmux select-pane -t 3
tmux send-keys "ros2 run nav2_map_server map_server --ros-args -r __node:=filter_mask_server --params-file /home/create/create_ws/src/deployment/config/nav2_params_keepout.yaml" Enter

# CostMap
tmux select-pane -t 4
tmux send-keys "ros2 run nav2_map_server costmap_filter_info_server --ros-args -r __node:=costmap_filter_info_server --params-file /home/create/create_ws/src/deployment/config/nav2_params_keepout.yaml" Enter

# Lifecycle Manager
tmux select-pane -t 5
tmux send-keys "ros2 run nav2_lifecycle_manager lifecycle_manager --ros-args -r __node:=lifecycle_manager_costmap_filters -p \"use_sim_time:=True\" -p \"autostart:=True\" -p \"node_names:=['filter_mask_server', 'costmap_filter_info_server']\"" Enter

# Attach to the tmux session
tmux -2 attach-session -t $session_name