import tensorflow_datasets as tfds
from dlimp.dataset import DLataset
import numpy as np
import tensorflow as tf
import cv2

def main():
    dataset_builder = tfds.builder(<DATASET NAME>, data_dir=<DATA DIR>) # loads most recent version   
    dataset = (
        DLataset.from_rlds(dataset_builder)
        .filter(lambda traj: traj["_len"][0] >= 30)
    )

    # first trajectory is the goal loop
    dataset_iter = iter(dataset)
    one_step = next(dataset_iter)

    step_size = 4
    
    save_data = {}
    save_data["data/position"] = one_step["observation"]["position"][::step_size]
    save_data["data/orientation"] = one_step["observation"]["orientation"][::step_size]
    save_data["data/image"] = [tf.io.decode_image(pic, expand_animations = False) for pic in one_step["observation"]["image"] ][::step_size]
    save_data["data/image"] = [cv2.resize(np.array(img), dsize=(64,64), interpolation=cv2.INTER_CUBIC) for img in save_data["data/image"]]

    np.savez('./goal_loop.npz', **save_data)


if __name__ == "__main__":
    main()
