import sys, select


def input_with_timeout(prompt: str, timeout_secs: int) -> str:
    print(prompt, end="", flush=True)
    result_fds = select.select([sys.stdin], [], [], timeout_secs)[0]
    if len(result_fds) == 0:
        return None

    result_fd = result_fds[0]

    return next(result_fd).rstrip()

if __name__ == '__main__':
    result = input_with_timeout("Enter text:", 10)
    print(f"Got '{result}'")
