# python run_in_script_8X7.py --checkpoints2 --models_and_datas=models_and_datas_full_qwen_7b --smaller_batch=1 --output=03107b --tests=base8X7whole
import os,glob,threading,subprocess
import torch, itertools
from models_and_datas import get_models_and_datas
from huggingface_hub import login
from huggingface_hub import login
import time,argparse,random,json
from conflict import conflict_between

parser = argparse.ArgumentParser()
parser.add_argument("--models_and_datas", type=str, default="lots_of_loras")
parser.add_argument("--output", type=str, default='output/0512loracompare/')
args = parser.parse_args()


print("Number of GPUs:", torch.cuda.device_count())
for i in range(torch.cuda.device_count()):
    print(f"GPU {i}: {torch.cuda.get_device_name(i)}")
        
gpus = int(torch.cuda.device_count())

output_folder = "output/test0301_full"

threads = {}
for i in range(gpus):
    threads[i] = None

def simple_run(cmd):

    print(cmd)
    subprocess.call([cmd],shell=True)

def get_running(target, cmd, extra = ''):
    while True:
        Done = False
        for k in range(gpus):
            if threads[k] is None or not threads[k].is_alive():
                thread = threading.Thread(target=target, \
                    args = tuple([cmd]))
                threads[k] = thread
                threads[k].setDaemon(True)
                threads[k].start()
                Done = True
                break
        if Done:
            break
        # time.sleep(60)
for i in range(1,9):
    cmd = f'CUDA_VISIBLE_DEVICES={i-1} python compare_lora_models.py --models_and_datas={args.models_and_datas}{i} --folder_name={args.output}{i}'
    get_running(simple_run, cmd)
    
for k in range(gpus):
    t = threads[k]
    if t is not None and t.is_alive():
        t.join()


