
models_and_datas_3 = {
    'base': {
        'model':["meta-llama/Meta-Llama-3-8B"],
        'datasets':[]
    },
    'guard': {
        'model':["meta-llama/Meta-Llama-Guard-2-8B"],
        'datasets':['toxic-chat']
    },
    
    'korean': { # performs badly???
        'model':["MLP-KTLim/llama-3-Korean-Bllossom-8B"],
        'datasets':['kobest']
    },
    'chinese': { 
        # 'model':["shenzhi-wang/Llama3-8B-Chinese-Chat"],
        'model':["UnicomLLM/Unichat-llama3-Chinese-8B-28K"],
        'datasets':['ceval']
    },
    'italian': {
        'model':["DeepMount00/Llama-3-8b-Ita"],
        'datasets':['arc_it']
    },
    'math': {
        'model':["hkust-nlp/dart-math-llama3-8b-prop2diff"],
        'datasets':['minerva_math']
    },
    'medical': {
        'model':[],
        'datasets':[]
    },
    'code': {
        'model':['rombodawg/rombos_Replete-Coder-Llama3-8B'],
        'datasets':['humaneval']
    }
    # 'astro': {
    #     'model':['AstroMLab/AstroSage-8B'],
    #     'datasets':['astrobench']
    # }
}


models_and_datas_2 = {
    'base': {
        'model':["meta-llama/Llama-2-7b-hf"],
        'datasets':[]
    },
    'guard': {
        'model':["meta-llama/LlamaGuard-7b"],
        'datasets':['toxic-chat']
    },
        
    'reasoning': {
        'model':["meta-llama/Llama-2-7b-chat-hf"],
        'datasets':['arc_easy']
    },
    
    'math': {
        'model':["meta-math/MetaMath-7B-V1.0"],
        'datasets':['minerva_math']
    },
    'math1': {
        'model':["meta-math/MetaMath-Llemma-7B"],
        'datasets':['minerva_math']
    },

    'code': {
        'model':['codellama/CodeLlama-7b-Instruct-hf'],
        'datasets':['humaneval']
    },
    'code1':{
        'model':['ise-uiuc/Magicoder-S-CL-7B'],
        'datasets':['humaneval']
    }
    # 'astro': {
    #     'model':['AstroMLab/AstroSage-8B'],
    #     'datasets':['astrobench']
    # }
}


models_and_datas_3_1 = {
    'base': {
        'model':["meta-llama/Llama-3.1-8B"],
        'datasets':[]
    },
    
    'guard': {
        'model':["meta-llama/Meta-Llama-Guard-3-8B"],
        'datasets':['toxic-chat']
    },

    'code': {
        'model':["ValiantLabs/Llama3.1-8B-Enigma"],
        'datasets':['humaneval']
    },
    'korean': { # performs badly???
        'model':["dnotitia/Llama-DNA-1.0-8B-Instruct"],
        'datasets':['kobest']
    },
    # 'tool': {
    #     'model':["Team-ACE/ToolACE-8B"],
    #     'datasets':['bfcl']
    # },
    # 'astro': {
    #     'model':['AstroMLab/AstroSage-8B'],
    #     'datasets':[]
        
    # },
}



neulab = {
    'base': {
        'model':["microsoft/codebert-base-mlm"],
        'datasets':[]
    },
    
    'python': {
        'model':["neulab/codebert-python"],
        'datasets':['']
    },

    'js': {
        'model':["neulab/codebert-javascript"],
        'datasets':['']
    },
    # 'c': { 
    #     'model':["neulab/codebert-c"],
    #     'datasets':['']
    # },
    
    'cpp': { 
        'model':["neulab/codebert-cpp"],
        'datasets':['']
    },
    
    'java': { 
        'model':["neulab/codebert-java"],
        'datasets':['']
    },

}


models_and_datas_llama_test = {
    'base': {
        'model':["meta-llama/Llama-3.2-1B"],
        'datasets':[]
    },
    'sst2': { 
        'model':["my-llama/llama-Llama-3.2-1Bsst2"],
        'datasets':['sst2']
    },
    'cola': { 
        'model':["my-llama/llama-Llama-3.2-1Bcola"],
        'datasets':['cola']
    },
}

models_and_datas_llama = {
    'base': {
        'model':["meta-llama/Meta-Llama-3-8B"],
        'datasets':[]
    },
    'sst2': { 
        'model':["my-llama2/llama-Meta-Llama-3-8Bsst2"],
        'datasets':['sst2']
    },
    'cola': { 
        'model':["my-llama2/llama-Meta-Llama-3-8Bcola"],
        'datasets':['cola']
    },
    'rte': { 
        'model':["my-llama2/llama-Meta-Llama-3-8Brte"],
        'datasets':['rte']
    },
    'qnli': { 
        'model':["my-llama2/llama-Meta-Llama-3-8Bqnli"],
        'datasets':['qnli']
    },
    'mrpc': { 
        'model':["my-llama2/llama-Meta-Llama-3-8Bmrpc"],
        'datasets':['mrpc']
    },
    'wnli': { 
        'model':["my-llama2/llama-Meta-Llama-3-8Bwnli"],
        'datasets':['wnli']
    },
    'qqp': { 
        'model':["my-llama2/llama-Meta-Llama-3-8Bqqp"],
        'datasets':['qqp']
    },
    'mnli': { 
        'model':["my-llama2/llama-Meta-Llama-3-8Bmnli"],
        'datasets':['mnli']
    },
    
    
}


models_and_datas_llama_tuning = {
    'base': {
        'model':["meta-llama/Meta-Llama-3-8B"],
        'datasets':[]
    },
    'sst2': { 
        'model':["my-llama-fewshot/llama-Meta-Llama-3-8Bsst2"],
        'datasets':['sst2']
    },
    'cola': { 
        'model':["my-llama-fewshot/llama-Meta-Llama-3-8Bcola"],
        'datasets':['cola']
    },
    'rte': { 
        'model':["my-llama-fewshot/llama-Meta-Llama-3-8Brte"],
        'datasets':['rte']
    },
    'qnli': { 
        'model':["my-llama-fewshot/llama-Meta-Llama-3-8Bqnli"],
        'datasets':['qnli']
    },
    'mrpc': { 
        'model':["my-llama-fewshot/llama-Meta-Llama-3-8Bmrpc"],
        'datasets':['mrpc']
    },
    'wnli': { 
        'model':["my-llama-fewshot/llama-Meta-Llama-3-8Bwnli"],
        'datasets':['wnli']
    },
    'qqp': { 
        'model':["my-llama-fewshot/llama-Meta-Llama-3-8Bqqp"],
        'datasets':['qqp']
    },
    'mnli': { 
        'model':["my-llama-fewshot/llama-Meta-Llama-3-8Bmnli"],
        'datasets':['mnli']
    },
    
}


models_and_datas_qwen = {
    'base': {
        'model':["Qwen/Qwen2.5-3B-Instruct"],
        'datasets':[]
    },
    'sst2': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructsst2"],
        'datasets':['sst2']
    },
    'cola': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructcola"],
        'datasets':['cola']
    },
    'rte': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructrte"],
        'datasets':['rte']
    },
    'qnli': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructqnli"],
        'datasets':['qnli']
    },
    'mrpc': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructmrpc"],
        'datasets':['mrpc']
    },
    'wnli': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructwnli"],
        'datasets':['wnli']
    },
    'qqp': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructqqp"],
        'datasets':['qqp']
    },
    'mnli': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructmnli"],
        'datasets':['mnli']
    },
    
}

models_and_datas_qwen_code = {
    'base': {
        'model':["Qwen/Qwen2.5-3B-Instruct"],
        'datasets':[]
    },
    'clone_detection': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructclone_detection"],
        'datasets':['clone_detection']
    },
    'code_to_text': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructcode_to_text"],
        'datasets':['code_to_text']
    },
    'text_to_code': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructtext_to_code"],
        'datasets':['text_to_code']
    },
    'defect_detection': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructdefect_detection"],
        'datasets':['defect_detection']
    },
}



models_and_datas_full_qwen_3b = {**models_and_datas_qwen, **models_and_datas_qwen_code}
models_and_datas_full_qwen_7b = {}
models_and_datas_full_qwen_14b = {}

for i in models_and_datas_full_qwen_3b:
    models_and_datas_full_qwen_7b[i] = {
        'model':[models_and_datas_full_qwen_3b[i]['model'][0].replace('3B','7B')],
        'datasets':models_and_datas_full_qwen_3b[i]['datasets'],
    }
    models_and_datas_full_qwen_14b[i] = {
        'model':[models_and_datas_full_qwen_3b[i]['model'][0].replace('3B','14B')],
        'datasets':models_and_datas_full_qwen_3b[i]['datasets'],
    }
    


models_and_datas_llama_instruct = {
    'base': {
        'model':["meta-llama/Llama-3.1-8B-Instruct"],
        'datasets':[]
    },
    'sst2': { 
        'model':["my-llama8B/Llama-3.1-8B-Instructsst2"],
        'datasets':['sst2']
    },
    'cola': { 
        'model':["my-llama8B/Llama-3.1-8B-Instructcola"],
        'datasets':['cola']
    },
    'rte': { 
        'model':["my-llama8B/Llama-3.1-8B-Instructrte"],
        'datasets':['rte']
    },
    'qnli': { 
        'model':["my-llama8B/Llama-3.1-8B-Instructqnli"],
        'datasets':['qnli']
    },
    'mrpc': { 
        'model':["my-llama8B/Llama-3.1-8B-Instructmrpc"],
        'datasets':['mrpc']
    },
    'wnli': { 
        'model':["my-llama8B/Llama-3.1-8B-Instructwnli"],
        'datasets':['wnli']
    },
    'qqp': { 
        'model':["my-llama8B/Llama-3.1-8B-Instructqqp"],
        'datasets':['qqp']
    },
    'mnli': { 
        'model':["my-llama8B/Llama-3.1-8B-Instructmnli"],
        'datasets':['mnli']
    },
    
}


lots_of_lora = {
    'base': {
        'model':["mistralai/Mistral-7B-Instruct-v0.2"],
        'datasets':[]
    },

    'task110': {
        'model': ["Lots-of-LoRAs/Mistral-7B-Instruct-v0.2-4b-r16-task110"],
        'datasets': ['Lots-of-LoRAs/task110_logic2text_sentence_generation']
    },
    'task210': {
        'model': ["Lots-of-LoRAs/Mistral-7B-Instruct-v0.2-4b-r16-task210"],
        'datasets': ['Lots-of-LoRAs/task210_logic2text_structured_text_generation']
    },
    'task145': {
        'model': ["Lots-of-LoRAs/Mistral-7B-Instruct-v0.2-4b-r16-task145"],
        'datasets': ['Lots-of-LoRAs/task145_afs_argument_similarity_death_penalty']
    },


    'task062': {
        'model': ["Lots-of-LoRAs/Mistral-7B-Instruct-v0.2-4b-r16-task062"],
        'datasets': ['Lots-of-LoRAs/task062_bigbench_repeat_copy_logic']
    },
    'task105': {
        'model': ["Lots-of-LoRAs/Mistral-7B-Instruct-v0.2-4b-r16-task105"],
        'datasets': ['Lots-of-LoRAs/task105_story_cloze-rocstories_sentence_generation']
    },
    'task40': {
        'model': ["Lots-of-LoRAs/Mistral-7B-Instruct-v0.2-4b-r16-task330"],
        'datasets': ['Lots-of-LoRAs/task330_gap_answer_generation']
    },

    'task835': {
        'model': ["Lots-of-LoRAs/Mistral-7B-Instruct-v0.2-4b-r16-task835"],
        'datasets': ['Lots-of-LoRAs/task835_mathdataset_answer_generation']
    },
    'task1423': {
        'model': ["Lots-of-LoRAs/Mistral-7B-Instruct-v0.2-4b-r16-task1423"],
        'datasets': ['Lots-of-LoRAs/task1423_mathqa_geometry']
    },
    'task1424': {
        'model': ["Lots-of-LoRAs/Mistral-7B-Instruct-v0.2-4b-r16-task1424"],
        'datasets': ['Lots-of-LoRAs/task1424_mathqa_probability']
    },
}
# to test which branch
# models_and_datas = models_and_datas_full_qwen_3b


models_and_datas_t5_xl = {
    'base': {
        'model':["google/t5-v1_1-xl"],
        'datasets':[]
    },
    'sst2': { 
        'model':["my-t5-xl/t5-v1_1-xlsst2"],
        'datasets':['sst2']
    },
    'cola': { 
        'model':["my-t5-xl/t5-v1_1-xlcola"],
        'datasets':['cola']
    },
    'rte': { 
        'model':["my-t5-xl/t5-v1_1-xlrte"],
        'datasets':['rte']
    },
    'qnli': { 
        'model':["my-t5-xl/t5-v1_1-xlqnli"],
        'datasets':['qnli']
    },
    'mrpc': { 
        'model':["my-t5-xl/t5-v1_1-xlmrpc"],
        'datasets':['mrpc']
    },
    'wnli': { 
        'model':["my-t5-xl/t5-v1_1-xlwnli"],
        'datasets':['wnli']
    },
    'qqp': { 
        'model':["my-t5-xl/t5-v1_1-xlqqp"],
        'datasets':['qqp']
    },
    'mnli': { 
        'model':["my-t5-xl/t5-v1_1-xlmnli"],
        'datasets':['mnli']
    },
}

models_and_datas_t5_base = {}
models_and_datas_t5_large = {}
models_and_datas_t5_small = {}

for i in models_and_datas_t5_xl:
    models_and_datas_t5_base[i] = {
        'model':[models_and_datas_t5_xl[i]['model'][0].replace('xl','base')],
        'datasets':models_and_datas_t5_xl[i]['datasets'],
    }
    models_and_datas_t5_small[i] = {
        'model':[models_and_datas_t5_xl[i]['model'][0].replace('xl','small')],
        'datasets':models_and_datas_t5_xl[i]['datasets'],
    }
    models_and_datas_t5_large[i] = {
        'model':[models_and_datas_t5_xl[i]['model'][0].replace('xl','large')],
        'datasets':models_and_datas_t5_xl[i]['datasets'],
    }


models_and_datas_llama_glue = {
    'base': {
        'model':["meta-llama/Llama-3.2-3B-Instruct"],
        'datasets':[]
    },
    'sst2': { 
        'model':["my-llama3B/Llama-3.2-3B-Instructsst2"],
        'datasets':['sst2']
    },
    'cola': { 
        'model':["my-llama3B/Llama-3.2-3B-Instructcola"],
        'datasets':['cola']
    },
    'rte': { 
        'model':["my-llama3B/Llama-3.2-3B-Instructrte"],
        'datasets':['rte']
    },
    'qnli': { 
        'model':["my-llama3B/Llama-3.2-3B-Instructqnli"],
        'datasets':['qnli']
    },
    'mrpc': { 
        'model':["my-llama3B/Llama-3.2-3B-Instructmrpc"],
        'datasets':['mrpc']
    },
    'wnli': { 
        'model':["my-llama3B/Llama-3.2-3B-Instructwnli"],
        'datasets':['wnli']
    },
    'qqp': { 
        'model':["my-llama3B/Llama-3.2-3B-Instructqqp"],
        'datasets':['qqp']
    },
    'mnli': { 
        'model':["my-llama3B/Llama-3.2-3B-Instructmnli"],
        'datasets':['mnli']
    },
}

models_and_datas_sft = {
    'base': {
        'model':["Qwen/Qwen2.5-3B-Instruct"],
        'datasets':[]
    },
    # 'mnliwnli': { 
    #     'model':["sft--Qwen2.5-3B-Instructmnliwnli"],
    #     'datasets':['wnli']
    # },
    # 'qqpwnli': { 
    #     'model':["sft--Qwen2.5-3B-Instructqqpwnli"],
    #     'datasets':['wnli']
    # },
    # 'rtewnli': { 
    #     'model':["sft--Qwen2.5-3B-Instructrtewnli"],
    #     'datasets':['wnli']
    # },
    # 'wnlimnli': { 
    #     'model':["sft--Qwen2.5-3B-Instructwnlimnli"],
    #     'datasets':['mnli']
    # },
    # 'wnliqqp': { 
    #     'model':["sft--Qwen2.5-3B-Instructwnliqqp"],
    #     'datasets':['qqp']
    # },
    # 'wnlirte': { 
    #     'model':["sft--Qwen2.5-3B-Instructwnlirte"],
    #     'datasets':['rte']
    # },
    #     'colasst2': { 
    #     'model':["sft--Qwen2.5-3B-Instructcolasst2"],
    #     'datasets':['sst2']
    # },
    #     'sst2cola': { 
    #     'model':["sft--Qwen2.5-3B-Instructsst2cola"],
    #     'datasets':['cola']
    # },
  
            'mnlirte': { 
        'model':["sft--Qwen2.5-3B-Instructmnlirte"],
        'datasets':['rte']
    },
            'rtemnli': { 
        'model':["sft--Qwen2.5-3B-Instructrtemnli"],
        'datasets':['mnli']
    },


            'colarte': { 
        'model':["sft--Qwen2.5-3B-Instructcolarte"],
        'datasets':['rte']
    },        'rtecola': { 
        'model':["sft--Qwen2.5-3B-Instructrtecola"],
        'datasets':['cola']
    },

            'qqpqnli': { 
        'model':["sft--Qwen2.5-3B-Instructqqpqnli"],
        'datasets':['qnli']
    },        'qnliqqp': { 
        'model':["sft--Qwen2.5-3B-Instructqnliqqp"],
        'datasets':['qqp']
    },
}





models_and_datas_deepseek_cut = {
    'base': {
        'model':["deepseek-ai/deepseek-llm-7b-chat"],
        'datasets':[]
    },
    'sst2': { 
        'model':["my-ds7b--deepseek-llm-7b-chatsst2"],
        'datasets':['sst2']
    },
    'cola': { 
        'model':["my-ds7b--deepseek-llm-7b-chatcola"],
        'datasets':['cola']
    },
    'rte': { 
        'model':["my-ds7b--deepseek-llm-7b-chatrte"],
        'datasets':['rte']
    },
    'qnli': { 
        'model':["my-ds7b--deepseek-llm-7b-chatqnli"],
        'datasets':['qnli']
    },
    'mrpc': { 
        'model':["my-ds7b--deepseek-llm-7b-chatmrpc"],
        'datasets':['mrpc']
    },

    'mnli': { 
        'model':["my-ds7b--deepseek-llm-7b-chatmnli"],
        'datasets':['mnli']
    },
    
}

models_and_datas_deepseek = {
    'base': {
        'model':["deepseek-ai/deepseek-llm-7b-chat"],
        'datasets':[]
    },
    'sst2': { 
        'model':["my-ds7b--deepseek-llm-7b-chatsst2"],
        'datasets':['sst2']
    },
    'cola': { 
        'model':["my-ds7b--deepseek-llm-7b-chatcola"],
        'datasets':['cola']
    },
    'rte': { 
        'model':["my-ds7b--deepseek-llm-7b-chatrte"],
        'datasets':['rte']
    },
    'qnli': { 
        'model':["my-ds7b--deepseek-llm-7b-chatqnli"],
        'datasets':['qnli']
    },
    'mrpc': { 
        'model':["my-ds7b--deepseek-llm-7b-chatmrpc"],
        'datasets':['mrpc']
    },

    'mnli': { 
        'model':["my-ds7b--deepseek-llm-7b-chatmnli"],
        'datasets':['mnli']
    },
    'wnli': { 
        'model':["my-ds7b--deepseek-llm-7b-chatwnli"],
        'datasets':['wnli']
    },
    'qqp': { 
        'model':["my-ds7b--deepseek-llm-7b-chatqqp"],
        'datasets':['qqp']
    },
}

models_and_datas_qwen_cut = {
    'base': {
        'model':["Qwen/Qwen2.5-3B-Instruct"],
        'datasets':[]
    },
    'sst2': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructsst2"],
        'datasets':['sst2']
    },
    'cola': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructcola"],
        'datasets':['cola']
    },
    'rte': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructrte"],
        'datasets':['rte']
    },
    'qnli': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructqnli"],
        'datasets':['qnli']
    },
    'mrpc': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructmrpc"],
        'datasets':['mrpc']
    },

    'mnli': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructmnli"],
        'datasets':['mnli']
    },
    
}

models_and_datas_another_prompt = {
    'base': {
        'model':["Qwen/Qwen2.5-3B-Instruct"],
        'datasets':[]
    },
    'sst2': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructsst2"],
        'datasets':['sst2']
    },
    'cola': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructcola"],
        'datasets':['cola']
    },
    'rte': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructrte"],
        'datasets':['rte']
    },
    'qnli': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructqnli"],
        'datasets':['qnli']
    },
    'mrpc': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructmrpc"],
        'datasets':['mrpc']
    },
    'wnli': { 
        'model':["my-another_prompt/Qwen2.5-3B-Instructwnli"],
        'datasets':['wnli']
    },
    'qqp': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructqqp"],
        'datasets':['qqp']
    },
    'mnli': { 
        'model':["my-qwen3B/Qwen2.5-3B-Instructmnli"],
        'datasets':['mnli']
    },
    
}





from models_lots_of_loras import *
from models_cut import *

def get_models_and_datas(name):
    return globals()[name]



    