"""Configuration module"""

# Model configurations
MODELS = {
    "meta-llama/Meta-Llama-3.1-8B-Instruct": "Llama 3.1 8B",
    "google/gemma-3-1b-it": "Gemma 3 1B",
    "GraySwanAI/Llama-3-8B-Instruct-RR": "Llama 3 8B CB",
    "Unispac/Llama2-7B-Chat-Augmented": "Llama 2 7B DA",
}

# Attack configurations
ATTACKS = [
    ("autodan", dict(
        title_suffix="AutoDAN",
        cumulative=False,
        sample_params=lambda: {
            "generation_config": {"num_return_sequences": 50, "temperature": 0.7, "max_new_tokens": 256},
            "early_stopping_threshold": 0,
        },
        baseline_params=lambda: {
            "generation_config": {"num_return_sequences": 1, "temperature": 0.0, "max_new_tokens": 256},
        },
    )),
    ("beast", dict(
        title_suffix="BEAST",
        cumulative=False,
        sample_params=lambda: {
            "mask_undecided_tokens": False,
            "generation_config": {"num_return_sequences": 50, "temperature": 0.7, "max_new_tokens": 256},
        },
        baseline_params=lambda: {
            "mask_undecided_tokens": False,
            "generation_config": {"num_return_sequences": 1, "temperature": 0.0, "max_new_tokens": 256},
        },
    )),
    ("pair", dict(
        title_suffix="PAIR",
        cumulative=True,
        sample_params=lambda: {
            "generation_config": {"num_return_sequences": 50, "temperature": 0.7, "max_new_tokens": 256},
            "version": "0.0.2",
        },
        baseline_params=lambda: {
            "generation_config": {"num_return_sequences": 1, "temperature": 0.0, "max_new_tokens": 256},
            "version": "0.0.2",
        },
    )),
    ("gcg", dict(
        title_suffix="GCG",
        cumulative=False,
        sample_params=lambda: {
            "generation_config": {"num_return_sequences": 50, "temperature": 0.7, "max_new_tokens": 256},
            "num_steps": 250,
            "loss": "ce",
            "token_selection": "default",
            "use_prefix_cache": True,
        },
        baseline_params=lambda: {
            "generation_config": {"num_return_sequences": 1, "temperature": 0.0, "max_new_tokens": 256},
            "num_steps": 250,
            "loss": "ce",
            "token_selection": "default",
            "use_prefix_cache": True,
        },
    )),
    ("gcg", dict(
        title_suffix="GCG 500",
        cumulative=False,
        sample_params=lambda: {
            "generation_config": {"num_return_sequences": 500, "temperature": 0.7, "max_new_tokens": 256},
            "num_steps": 250,
            "loss": "ce",
            "token_selection": "default",
            "use_prefix_cache": True,
        },
        baseline_params=lambda: {
            "generation_config": {"num_return_sequences": 1, "temperature": 0.0, "max_new_tokens": 256},
            "num_steps": 250,
            "loss": "ce",
            "token_selection": "default",
            "use_prefix_cache": True,
        },
    )),
    ("gcg", dict(
        title_suffix="GCG Entropy Loss",
        cumulative=False,
        sample_params=lambda: {
            "generation_config": {"num_return_sequences": 50, "temperature": 0.7, "max_new_tokens": 256},
            "num_steps": 250,
            "loss": "entropy_adaptive",
            "token_selection": "default",
            "use_prefix_cache": True,
        },
        baseline_params=lambda: {
            "generation_config": {"num_return_sequences": 1, "temperature": 0.0, "max_new_tokens": 256},
            "num_steps": 250,
            "loss": "ce",
            "token_selection": "default",
            "use_prefix_cache": True,
        },
    )),
    ("gcg_reinforce", dict(
        title_suffix="GCG_REINFORCE",
        cumulative=False,
        sample_params=lambda: {
            "generation_config": {"num_return_sequences": 50, "temperature": 0.7, "max_new_tokens": 256},
            "num_steps": 250,
            "token_selection": "default",
            "token_position_weight_type": "exponential",
            "judge_model_id": "harmbench",
        },
        baseline_params=lambda: {
            "generation_config": {"num_return_sequences": 1, "temperature": 0.0, "max_new_tokens": 256},
            "num_steps": 250,
            "token_selection": "default",
            "token_position_weight_type": "exponential",
            "judge_model_id": "harmbench",
        },
    )),
    ("gcg_reinforce", dict(
        title_suffix="GCG_REINFORCE_SR",
        cumulative=False,
        sample_params=lambda: {
            "generation_config": {"num_return_sequences": 50, "temperature": 0.7, "max_new_tokens": 256},
            "num_steps": 250,
            "token_selection": "default",
            "token_position_weight_type": "exponential",
            "judge_model_id": "strong_reject",
        },
        baseline_params=lambda: {
            "generation_config": {"num_return_sequences": 1, "temperature": 0.0, "max_new_tokens": 256},
            "num_steps": 250,
            "token_selection": "default",
            "token_position_weight_type": "exponential",
            "judge_model_id": "strong_reject",
        },
    )),
]

# Analysis constants
METRIC = ("scores", "strong_reject", "p_harmful")
GROUP_BY = {"model", "attack_params"}
DATASET_IDX = list(range(100))

# Default plot parameters
DEFAULT_PLOT_PARAMS = {
    "color_scale": "sqrt",
    "threshold": None,
    "cumulative": False,
    "plot_points": True,
    "plot_frontiers": True,
    "plot_envelope": False,
    "verbose": True,
}

# Plot output directory
PLOT_OUTPUT_DIR = "evaluate/plots"  # Default plot directory

# Available analysis types
ANALYSIS_TYPES = [
    "pareto",
    "non_cumulative_pareto",
    "flops_ratio",
    "ideal_ratio",
    "histogram",
    "histogram_2",
    "ridge",
    "ridge_side_by_side",
    "ratio_plot",
    "flops_breakdown",
    "optimization_progress",
    "comparative_pareto",
    "multi_attack_non_cumulative_pareto",
    "bar_chart",
    "absolute_bar_chart"
]