import pandas as pd
import os
import numpy as np
import argparse

parser = argparse.ArgumentParser()
parser.add_argument('log_dir', type=str)
args = parser.parse_args()

df = pd.read_csv(os.path.join(args.log_dir, 'stats.tsv'), sep='\t')
best_idx = df['test_acc/source_val'].argmax()
best_id = np.around(df.loc[best_idx, 'test_acc/source_val'] * 100, 2)
best_ood = np.around(df.loc[best_idx, 'test_acc/target_val'] * 100, 2)
print(f'ID acc: {best_id}')
print(f'OOD acc: {best_ood}')
