#!/bin/bash
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=4
#SBATCH --mem=32G

set -x

breeds_name=$1
use_source=$2
use_target=$3
conda_env=${4:-`whoami`-ue}
port=${5:-":13321"}

echo "Running Breeds $1 exp with Source=$use_source and Target=$use_target"
echo "Using conda environment $conda_env"

master_node=${SLURM_NODELIST:0:9}${SLURM_NODELIST:9:4}
dist_url="tcp://"
dist_url+=$master_node
# dist_url+=:40000
dist_url+=$port

# COPY to local
LOCAL_IMAGENET_PATH=$HOME/imagenet
DATASET_PATH=$LOCAL_IMAGENET_PATH


echo "Using ImageNet data from $DATASET_PATH"
EXPERIMENT_NAME="breeds_${breeds_name}_source_${use_source}_target_${use_target}"
echo "Experiment name: $EXPERIMENT_NAME"
EXPERIMENT_PATH="checkpoints/$EXPERIMENT_NAME"
echo "Using checkpoints from $EXPERIMENT_PATH"
EXPERIMENT_PATH_FULL="$EXPERIMENT_PATH/eval_fullft"
mkdir -p $EXPERIMENT_PATH_FULL
echo "Results saved in $EXPERIMENT_PATH_FULL"


PRETRAINED=$EXPERIMENT_PATH/checkpoints/ckp-199.pth
if [ ! -f $PRETRAINED ]; then

conda activate $conda_env
# convert checkpoint
python convert_checkpoints.py --pretrained $PRETRAINED --arch resnet50
conda deactivate
fi

PYTHON_CMD=.env/bin/python
srun --output=${EXPERIMENT_PATH_FULL}/%j.out --error=${EXPERIMENT_PATH_FULL}/%j.err --label $PYTHON_CMD -u eval_semisup.py \
--data_path $DATASET_PATH \
--pretrained $PRETRAINED.oldformat \
--epochs 100 \
--batch_size 32 \
--arch resnet50 \
--dump_path $EXPERIMENT_PATH_FULL \
--dataset_name breeds \
--dist_url $dist_url \
--workers 10 \
--dataset_kwargs breeds_name=$breeds_name

# for interactive
# $PYTHON_CMD -m torch.distributed.launch --nproc_per_node=1 eval_semisup.py \
# --is_not_slurm_job True \

