

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
from __future__ import unicode_literals


class Observable(object):
    '''Simple implementation of the observer pattern'''

    def __init__(self):
        self.observers = []

    def register(self, callback):
        self.observers.append(callback)

    def deregister(self, callback):
        self.observers.remove(callback)

    def __call__(self, *args):
        for c in self.observers:
            c(*args)
