import requests
import base64
import json
import os
from tqdm import tqdm
import argparse

# 命令行参数解析
parser = argparse.ArgumentParser()

parser.add_argument("--num", type=int, required=True, help="")

args = parser.parse_args()
num = args.num

# 文件路径
jsonl_path = 'results.jsonl'
output_path = f'results_{num}.jsonl'

url = ""
headers = {
    "Accept": "application/json",
    "Authorization": "",
    "Content-Type": "application/json"
}

with open(jsonl_path, "r", encoding="utf-8") as fin, open(output_path, "w", encoding="utf-8") as fout:
    for line in tqdm(fin):
        while True:
            item = json.loads(line)
            audio_path = item["audio_path"]
            question = item["question"]
            
            print(audio_path)
            data = {
                "model": "gemini-2.5-pro-preview-05-06",
                "messages": [
                    {
                        "role": "user",
                        "content": [
                            {
                                "type": "text",
                                "text":  question
                            },
                            {
                                "type": "image_url",
                                "image_url": {
                                    "url": audio_path
                                }
                            }
                        ]
                    }
                ]
            }
            try:
                response = requests.post(url, headers=headers, json=data)
                resp_json = response.json()
                print(resp_json)
                prediction = resp_json.get("choices", [{}])[0].get("message", {}).get("content", "")
                if prediction=="":
                    continue
                else:
                    item["prediction"] = prediction
                    fout.write(json.dumps(item, ensure_ascii=False) + "\n")
                    break
            except Exception as e:
                prediction = f"[ERROR]{str(e)}"
                continue
                



