# Copyright (2024) Tsinghua University, Bytedance Ltd. and/or its affiliates
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import argparse
from tqdm import tqdm
import torch
from transformers import WhisperFeatureExtractor

from config import Config
from models.salmonn import SALMONN
from utils import prepare_one_sample


# python /mnt/dolphinfs/hdd_pool/docker/user/hadoop-fsprisk/fudongjie/benchmark/kimi/more_model/SALMONN/cli_inference.py --device cuda:0 --output_path /mnt/dolphinfs/hdd_pool/docker/user/hadoop-fsprisk/fudongjie/benchmark/kimi/eval_result/salmoon7b/result_0

parser = argparse.ArgumentParser()
parser.add_argument("--cfg-path", type=str,  default='')
parser.add_argument("--device", type=str, default="cuda")
parser.add_argument("--output_path", type=str)
parser.add_argument(
    "--options",
    nargs="+",
    help="override some settings in the used config, the key-value pair "
    "in xxx=yyy format will be merged into config file (deprecate), "
    "change to --cfg-options instead.",

)

args = parser.parse_args()
cfg = Config(args)

model = SALMONN.from_config(cfg.config.model)
model.to(args.device)
model.eval()

wav_processor = WhisperFeatureExtractor.from_pretrained(cfg.config.model.whisper_path)
import json

input_jsonl_path = '/'   # 输入jsonl文件路径
# output_jsonl_path = '/mnt/dolphinfs/hdd_pool/docker/user/hadoop-fsprisk/fudongjie/benchmark/kimi/more_model/SALMONN/eval/output_7b.jsonl' # 输出jsonl文件路径
output_jsonl_path = args.output_path
results = []



with open(input_jsonl_path, 'r', encoding='utf-8') as f:
    total_lines = sum(1 for _ in f)
with open(input_jsonl_path, 'r', encoding='utf-8') as fin:
    for line in tqdm(fin, total=total_lines, desc="Processing"):
        try:
            data = json.loads(line)
            wav_path = data.get("audio_path")
            question = data.get("question")
            type0 = data.get("type")
            samples = prepare_one_sample(wav_path, wav_processor)

            if 'asr' in type0:
                if type0.split('_')[-1]=='zh':
                    prompt = [f'USER: <Speech><SpeechHere></Speech> 请将语音中的内容写下来。\nASSISTANT:']
                else:
                    prompt = [f'USER: <Speech><SpeechHere></Speech> Recognize the speech and give me the transcription. \nASSISTANT:']
            else:
                prompt = [f'USER: <Speech><SpeechHere></Speech>{question}\nASSISTANT:']

            # for environment with cuda>=117
            with torch.cuda.amp.autocast(dtype=torch.float16):
                prediction = model.generate(samples, cfg.config.generate, prompts=prompt)[0]
            data["prediction"] = prediction
            print(data["prediction"])
        except Exception as e:
            data["prediction"] = f"Error: {str(e)}"
            print(data["prediction"])
        results.append(data)

with open(output_jsonl_path, 'w', encoding='utf-8') as fout:
    for item in results:
        fout.write(json.dumps(item, ensure_ascii=False) + '\n')


